/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.inmemory;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaRepository;

public class InMemorySagaRepository
implements SagaRepository {
    private final ConcurrentMap<String, Saga> managedSagas = new ConcurrentHashMap<String, Saga>();

    @Override
    public Set<String> find(Class<? extends Saga> type, AssociationValue associationValue) {
        TreeSet<String> result = new TreeSet<String>();
        for (Saga saga : this.managedSagas.values()) {
            if (!saga.getAssociationValues().contains(associationValue) || !type.isInstance(saga)) continue;
            result.add(saga.getSagaIdentifier());
        }
        return result;
    }

    @Override
    public Saga load(String sagaIdentifier) {
        return (Saga)this.managedSagas.get(sagaIdentifier);
    }

    @Override
    public void commit(Saga saga) {
        if (!saga.isActive()) {
            this.managedSagas.remove(saga.getSagaIdentifier());
        } else {
            this.managedSagas.put(saga.getSagaIdentifier(), saga);
        }
        saga.getAssociationValues().commit();
    }

    @Override
    public void add(Saga saga) {
        this.commit(saga);
    }

    public int size() {
        return this.managedSagas.size();
    }
}

