/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository;

import java.util.Set;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.AssociationValues;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaRepository;

public abstract class AbstractSagaRepository
implements SagaRepository {
    @Override
    public Set<String> find(Class<? extends Saga> type, AssociationValue associationValue) {
        return this.findAssociatedSagaIdentifiers(type, associationValue);
    }

    @Override
    public void add(Saga saga) {
        if (saga.isActive()) {
            String sagaType = this.typeOf(saga.getClass());
            AssociationValues associationValues = saga.getAssociationValues();
            for (AssociationValue av : associationValues.addedAssociations()) {
                this.storeAssociationValue(av, sagaType, saga.getSagaIdentifier());
            }
            associationValues.commit();
            this.storeSaga(saga);
        }
    }

    @Override
    public void commit(Saga saga) {
        if (!saga.isActive()) {
            this.deleteSaga(saga);
        } else {
            String sagaType = this.typeOf(saga.getClass());
            AssociationValues associationValues = saga.getAssociationValues();
            for (AssociationValue associationValue : associationValues.addedAssociations()) {
                this.storeAssociationValue(associationValue, sagaType, saga.getSagaIdentifier());
            }
            for (AssociationValue associationValue : associationValues.removedAssociations()) {
                this.removeAssociationValue(associationValue, sagaType, saga.getSagaIdentifier());
            }
            associationValues.commit();
            this.updateSaga(saga);
        }
    }

    protected abstract Set<String> findAssociatedSagaIdentifiers(Class<? extends Saga> var1, AssociationValue var2);

    protected abstract String typeOf(Class<? extends Saga> var1);

    protected abstract void deleteSaga(Saga var1);

    protected abstract void updateSaga(Saga var1);

    protected abstract void storeSaga(Saga var1);

    protected abstract void storeAssociationValue(AssociationValue var1, String var2, String var3);

    protected abstract void removeAssociationValue(AssociationValue var1, String var2, String var3);
}

