/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import java.io.Serializable;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.IdentifierFactory;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.AssociationValues;
import org.axonframework.saga.Saga;
import org.axonframework.saga.annotation.AssociationValuesImpl;
import org.axonframework.saga.annotation.SagaMethodMessageHandler;
import org.axonframework.saga.annotation.SagaMethodMessageHandlerInspector;

public abstract class AbstractAnnotatedSaga
implements Saga,
Serializable {
    private static final long serialVersionUID = 2385024168304711298L;
    private final AssociationValues associationValues = new AssociationValuesImpl();
    private final String identifier;
    private volatile transient SagaMethodMessageHandlerInspector<? extends AbstractAnnotatedSaga> inspector;
    private volatile boolean isActive = true;
    private transient ParameterResolverFactory parameterResolverFactory;

    protected AbstractAnnotatedSaga() {
        this(IdentifierFactory.getInstance().generateIdentifier());
    }

    protected AbstractAnnotatedSaga(String identifier) {
        this.identifier = identifier;
        this.associationValues.add(new AssociationValue("sagaIdentifier", identifier));
    }

    @Override
    public String getSagaIdentifier() {
        return this.identifier;
    }

    @Override
    public AssociationValues getAssociationValues() {
        return this.associationValues;
    }

    @Override
    public final void handle(EventMessage event) {
        if (this.isActive) {
            this.ensureInspectorInitialized();
            SagaMethodMessageHandler handler = this.inspector.findHandlerMethod(this, event);
            handler.invoke(this, event);
            if (handler.isEndingHandler()) {
                this.end();
            }
        }
    }

    private void ensureInspectorInitialized() {
        if (this.inspector == null) {
            if (this.parameterResolverFactory == null) {
                this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(this.getClass());
            }
            this.inspector = SagaMethodMessageHandlerInspector.getInstance(this.getClass(), this.parameterResolverFactory);
        }
    }

    protected void registerParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    protected void end() {
        this.isActive = false;
    }

    protected void associateWith(AssociationValue property) {
        this.associationValues.add(property);
    }

    protected void associateWith(String key, String value) {
        this.associationValues.add(new AssociationValue(key, value));
    }

    protected void associateWith(String key, Number value) {
        this.associateWith(key, value.toString());
    }

    protected void removeAssociationWith(AssociationValue property) {
        this.associationValues.remove(property);
    }

    protected void removeAssociationWith(String key, String value) {
        this.associationValues.remove(new AssociationValue(key, value));
    }

    protected void removeAssociationWith(String key, Number value) {
        this.removeAssociationWith(key, value.toString());
    }
}

