/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.repository;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.repository.LockManager;

public class OptimisticLockManager
implements LockManager {
    private final ConcurrentHashMap<Object, OptimisticLock> locks = new ConcurrentHashMap();

    @Override
    public boolean validateLock(AggregateRoot aggregate) {
        OptimisticLock lock = this.locks.get(aggregate.getIdentifier());
        return lock != null && lock.validate(aggregate);
    }

    @Override
    public void obtainLock(Object aggregateIdentifier) {
        boolean obtained = false;
        while (!obtained) {
            this.locks.putIfAbsent(aggregateIdentifier, new OptimisticLock());
            OptimisticLock lock = this.locks.get(aggregateIdentifier);
            obtained = lock != null && lock.lock();
            if (obtained) continue;
            this.locks.remove(aggregateIdentifier, lock);
        }
    }

    @Override
    public void releaseLock(Object aggregateIdentifier) {
        OptimisticLock lock = this.locks.get(aggregateIdentifier);
        if (lock != null) {
            lock.unlock(aggregateIdentifier);
        }
    }

    private final class OptimisticLock {
        private Long versionNumber;
        private final Map<Thread, Integer> threadsHoldingLock = new WeakHashMap<Thread, Integer>();
        private boolean closed = false;

        private OptimisticLock() {
        }

        private synchronized boolean validate(AggregateRoot aggregate) {
            Long lastCommittedEventSequenceNumber = aggregate.getVersion();
            if (this.versionNumber == null || this.versionNumber.equals(lastCommittedEventSequenceNumber)) {
                long last = lastCommittedEventSequenceNumber == null ? 0L : lastCommittedEventSequenceNumber;
                this.versionNumber = last + (long)aggregate.getUncommittedEventCount();
                return true;
            }
            return false;
        }

        private synchronized boolean lock() {
            if (this.closed) {
                return false;
            }
            Integer lockCount = this.threadsHoldingLock.get(Thread.currentThread());
            if (lockCount == null) {
                lockCount = 0;
            }
            this.threadsHoldingLock.put(Thread.currentThread(), lockCount + 1);
            return true;
        }

        private synchronized void unlock(Object aggregateIdentifier) {
            Integer lockCount = this.threadsHoldingLock.get(Thread.currentThread());
            if (lockCount == null || lockCount == 1) {
                this.threadsHoldingLock.remove(Thread.currentThread());
            } else {
                this.threadsHoldingLock.put(Thread.currentThread(), lockCount - 1);
            }
            if (this.threadsHoldingLock.isEmpty()) {
                this.closed = true;
                OptimisticLockManager.this.locks.remove(aggregateIdentifier, this);
            }
        }
    }
}

