/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.repository;

import org.axonframework.common.Assert;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.repository.AbstractRepository;
import org.axonframework.repository.ConcurrencyException;
import org.axonframework.repository.LockManager;
import org.axonframework.repository.PessimisticLockManager;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LockingRepository<T extends AggregateRoot>
extends AbstractRepository<T> {
    private static final Logger logger = LoggerFactory.getLogger(LockingRepository.class);
    private final LockManager lockManager;

    protected LockingRepository(Class<T> aggregateType) {
        this(aggregateType, new PessimisticLockManager());
    }

    protected LockingRepository(Class<T> aggregateType, LockManager lockManager) {
        super(aggregateType);
        Assert.notNull(lockManager, "lockManager may not be null");
        this.lockManager = lockManager;
    }

    @Override
    public void add(T aggregate) {
        Object aggregateIdentifier = aggregate.getIdentifier();
        this.lockManager.obtainLock(aggregateIdentifier);
        try {
            super.add(aggregate);
            CurrentUnitOfWork.get().registerListener(new LockCleaningListener(aggregateIdentifier));
        }
        catch (RuntimeException ex) {
            logger.debug("Exception occurred while trying to add an aggregate. Releasing lock.", (Throwable)ex);
            this.lockManager.releaseLock(aggregateIdentifier);
            throw ex;
        }
    }

    @Override
    public T load(Object aggregateIdentifier, Long expectedVersion) {
        this.lockManager.obtainLock(aggregateIdentifier);
        try {
            Object aggregate = super.load(aggregateIdentifier, expectedVersion);
            CurrentUnitOfWork.get().registerListener(new LockCleaningListener(aggregateIdentifier));
            return (T)aggregate;
        }
        catch (RuntimeException ex) {
            logger.debug("Exception occurred while trying to load an aggregate. Releasing lock.", (Throwable)ex);
            this.lockManager.releaseLock(aggregateIdentifier);
            throw ex;
        }
    }

    @Override
    protected final void doSave(T aggregate) {
        if (aggregate.getVersion() != null && !this.lockManager.validateLock((AggregateRoot)aggregate)) {
            throw new ConcurrencyException(String.format("The aggregate of type [%s] with identifier [%s] could not be saved, as a valid lock is not held. Either another thread has saved an aggregate, or the current thread had released its lock earlier on.", aggregate.getClass().getSimpleName(), aggregate.getIdentifier()));
        }
        this.doSaveWithLock(aggregate);
    }

    @Override
    protected final void doDelete(T aggregate) {
        if (aggregate.getVersion() != null && !this.lockManager.validateLock((AggregateRoot)aggregate)) {
            throw new ConcurrencyException(String.format("The aggregate of type [%s] with identifier [%s] could not be saved, as a valid lock is not held. Either another thread has saved an aggregate, or the current thread had released its lock earlier on.", aggregate.getClass().getSimpleName(), aggregate.getIdentifier()));
        }
        this.doDeleteWithLock(aggregate);
    }

    protected abstract void doSaveWithLock(T var1);

    protected abstract void doDeleteWithLock(T var1);

    @Override
    protected abstract T doLoad(Object var1, Long var2);

    private class LockCleaningListener
    extends UnitOfWorkListenerAdapter {
        private final Object aggregateIdentifier;

        public LockCleaningListener(Object aggregateIdentifier) {
            this.aggregateIdentifier = aggregateIdentifier;
        }

        @Override
        public void onCleanup(UnitOfWork unitOfWork) {
            LockingRepository.this.lockManager.releaseLock(this.aggregateIdentifier);
        }
    }
}

