/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.supporting;

import java.util.ArrayList;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventVisitor;
import org.axonframework.eventstore.management.Criteria;
import org.axonframework.eventstore.management.CriteriaBuilder;
import org.axonframework.eventstore.management.EventStoreManagement;
import org.axonframework.eventstore.supporting.TimestampCutoffReadonlyEventStore;
import org.joda.time.DateTime;

public class VolatileEventStore
implements EventStore,
EventStoreManagement {
    private final ArrayList<AggregateTypedEventMessage> volatileEvents = new ArrayList();

    @Override
    public synchronized void visitEvents(EventVisitor visitor) {
        for (AggregateTypedEventMessage eventMessage : this.volatileEvents) {
            visitor.doWithEvent(eventMessage.eventMessage);
        }
    }

    @Override
    public synchronized void visitEvents(Criteria criteria, EventVisitor visitor) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public CriteriaBuilder newCriteriaBuilder() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public synchronized void appendEvents(String type, DomainEventStream events) {
        while (events.hasNext()) {
            AggregateTypedEventMessage obj = new AggregateTypedEventMessage();
            obj.type = type;
            obj.eventMessage = events.next();
            this.volatileEvents.add(obj);
        }
    }

    @Override
    public synchronized DomainEventStream readEvents(String type, Object identifier) {
        ArrayList selection = new ArrayList();
        for (AggregateTypedEventMessage typedMessage : this.volatileEvents) {
            DomainEventMessage<?> evMsg;
            if (!typedMessage.type.equals(type) || !identifier.equals((evMsg = typedMessage.eventMessage).getAggregateIdentifier())) continue;
            selection.add(typedMessage.eventMessage);
        }
        return new SimpleDomainEventStream(selection);
    }

    public TimestampCutoffReadonlyEventStore cutoff(DateTime cutOffTimestamp) {
        return new TimestampCutoffReadonlyEventStore(this, this, cutOffTimestamp);
    }

    static class AggregateTypedEventMessage {
        String type;
        DomainEventMessage<?> eventMessage;

        AggregateTypedEventMessage() {
        }
    }
}

