/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.supporting;

import java.io.Closeable;
import java.io.IOException;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStreamNotFoundException;
import org.axonframework.eventstore.EventVisitor;
import org.axonframework.eventstore.management.Criteria;
import org.axonframework.eventstore.management.CriteriaBuilder;
import org.axonframework.eventstore.management.EventStoreManagement;

public class SequenceEventStore
implements EventStore,
EventStoreManagement {
    private final EventStore first;
    private final EventStoreManagement firstManagement;
    private final EventStore second;
    private final EventStoreManagement secondManagement;

    public SequenceEventStore(EventStore second, EventStoreManagement secondManagement, EventStore first, EventStoreManagement firstManagement) {
        this.second = second;
        this.secondManagement = secondManagement;
        this.first = first;
        this.firstManagement = firstManagement;
    }

    @Override
    public synchronized void visitEvents(EventVisitor visitor) {
        this.firstManagement.visitEvents(visitor);
        this.secondManagement.visitEvents(visitor);
    }

    @Override
    public synchronized void visitEvents(Criteria criteria, EventVisitor visitor) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public CriteriaBuilder newCriteriaBuilder() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public synchronized void appendEvents(String type, DomainEventStream events) {
        this.second.appendEvents(type, events);
    }

    @Override
    public synchronized DomainEventStream readEvents(String type, Object identifier) {
        return new JoinedDomainEventStream(this.firstReadEventsIgnoreMissing(type, identifier), this.second.readEvents(type, identifier));
    }

    private DomainEventStream firstReadEventsIgnoreMissing(String type, Object identifier) {
        try {
            return this.first.readEvents(type, identifier);
        }
        catch (EventStreamNotFoundException e) {
            return new SimpleDomainEventStream(new DomainEventMessage[0]);
        }
    }

    private static final class JoinedDomainEventStream
    implements DomainEventStream,
    Closeable {
        private final DomainEventStream events1;
        private final DomainEventStream events2;
        private DomainEventMessage next;

        public JoinedDomainEventStream(DomainEventStream events1, DomainEventStream events2) {
            this.events1 = events1;
            this.events2 = events2;
            this.next = this.findNextItem();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public synchronized DomainEventMessage next() {
            DomainEventMessage current = this.next;
            this.next = this.findNextItem();
            return current;
        }

        private DomainEventMessage findNextItem() {
            if (this.events1.hasNext()) {
                return this.events1.next();
            }
            if (this.events2.hasNext()) {
                return this.events2.next();
            }
            return null;
        }

        @Override
        public DomainEventMessage peek() {
            return this.next;
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeIfCloseable(this.events1);
            IOUtils.closeIfCloseable(this.events2);
        }
    }
}

