/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jpa;

import java.sql.SQLException;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;

public class SQLStateResolver
implements PersistenceExceptionResolver {
    private static final String INTEGRITY_CONSTRAINT_VIOLATION_CODE = "23";
    private String checkCode = null;

    public SQLStateResolver() {
        this.checkCode = INTEGRITY_CONSTRAINT_VIOLATION_CODE;
    }

    public SQLStateResolver(String checkState) {
        this.checkCode = checkState;
    }

    @Override
    public boolean isDuplicateKeyViolation(Exception exception) {
        boolean isDuplicateKey = false;
        SQLException sqlException = this.findSQLException(exception);
        if (sqlException != null && sqlException.getSQLState() != null && sqlException.getSQLState().startsWith(this.checkCode)) {
            isDuplicateKey = true;
        }
        return isDuplicateKey;
    }

    private SQLException findSQLException(Throwable exception) {
        SQLException sqlException = null;
        while (sqlException == null && exception != null) {
            if (exception instanceof SQLException) {
                sqlException = (SQLException)exception;
                continue;
            }
            exception = exception.getCause();
        }
        return sqlException;
    }
}

