/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.eventstore.fs.EventFileResolver;

public class SimpleEventFileResolver
implements EventFileResolver {
    public static final String FILE_EXTENSION_EVENTS = "events";
    public static final String FILE_EXTENSION_SNAPSHOTS = "snapshots";
    private final File baseDir;

    public SimpleEventFileResolver(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public OutputStream openEventFileForWriting(String type, Object aggregateIdentifier) throws IOException {
        File eventFile = this.getEventsFile(type, aggregateIdentifier, FILE_EXTENSION_EVENTS);
        return new BufferedOutputStream(new FileOutputStream(eventFile, true));
    }

    @Override
    public OutputStream openSnapshotFileForWriting(String type, Object aggregateIdentifier) throws IOException {
        return new FileOutputStream(this.getEventsFile(type, aggregateIdentifier, FILE_EXTENSION_SNAPSHOTS), true);
    }

    @Override
    public InputStream openEventFileForReading(String type, Object identifier) throws IOException {
        return new FileInputStream(this.getEventsFile(type, identifier, FILE_EXTENSION_EVENTS));
    }

    @Override
    public InputStream openSnapshotFileForReading(String type, Object identifier) throws IOException {
        return new FileInputStream(this.getEventsFile(type, identifier, FILE_EXTENSION_SNAPSHOTS));
    }

    @Override
    public boolean eventFileExists(String type, Object identifier) throws IOException {
        return this.getEventsFile(type, identifier, FILE_EXTENSION_EVENTS).exists();
    }

    @Override
    public boolean snapshotFileExists(String type, Object identifier) throws IOException {
        return this.getEventsFile(type, identifier, FILE_EXTENSION_SNAPSHOTS).exists();
    }

    private File getEventsFile(String type, Object identifier, String extension) throws IOException {
        return new File(this.getBaseDirForType(type), SimpleEventFileResolver.fsSafeIdentifier(identifier) + "." + extension);
    }

    private static String fsSafeIdentifier(Object id) {
        try {
            return URLEncoder.encode(id.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("System doesn't support UTF-8?", e);
        }
    }

    private File getBaseDirForType(String type) {
        File typeSpecificDir = new File(this.baseDir, type);
        if (!(typeSpecificDir.exists() || typeSpecificDir.mkdirs() || typeSpecificDir.exists())) {
            throw new EventStoreException("The given event store directory doesn't exist and could not be created");
        }
        return typeSpecificDir;
    }
}

