/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.eventstore.fs.FileSystemEventMessageReader;
import org.axonframework.eventstore.fs.FileSystemEventMessageWriter;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.Serializer;

public class FileSystemSnapshotEventWriter {
    private final InputStream eventFile;
    private final OutputStream snapshotEventFile;
    private final Serializer eventSerializer;

    public FileSystemSnapshotEventWriter(InputStream eventFile, OutputStream snapshotEventFile, Serializer eventSerializer) {
        this.eventFile = eventFile;
        this.snapshotEventFile = snapshotEventFile;
        this.eventSerializer = eventSerializer;
    }

    public void writeSnapshotEvent(DomainEventMessage snapshotEvent) {
        try {
            long offset = this.calculateOffset(snapshotEvent);
            DataOutputStream dataOutputStream = new DataOutputStream(this.snapshotEventFile);
            dataOutputStream.writeLong(offset);
            FileSystemEventMessageWriter eventMessageWriter = new FileSystemEventMessageWriter(dataOutputStream, this.eventSerializer);
            eventMessageWriter.writeEventMessage(snapshotEvent);
        }
        catch (IOException e) {
            throw new EventStoreException("Error writing a snapshot event due to an IO exception", e);
        }
        finally {
            IOUtils.closeQuietly(this.snapshotEventFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateOffset(DomainEventMessage snapshotEvent) throws IOException {
        long l;
        CountingInputStream countingInputStream = null;
        try {
            countingInputStream = new CountingInputStream((InputStream)new BufferedInputStream(this.eventFile));
            FileSystemEventMessageReader eventMessageReader = new FileSystemEventMessageReader(new DataInputStream((InputStream)countingInputStream));
            long lastReadSequenceNumber = -1L;
            while (lastReadSequenceNumber < snapshotEvent.getSequenceNumber()) {
                SerializedDomainEventData entry = eventMessageReader.readEventMessage();
                lastReadSequenceNumber = entry.getSequenceNumber();
            }
            l = countingInputStream.getByteCount();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(countingInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)countingInputStream);
        return l;
    }
}

