/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventstore.fs.FileSystemEventMessageReader;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedDomainEventMessage;
import org.axonframework.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSnapshotEventReader {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemSnapshotEventReader.class);
    private final InputStream eventFile;
    private final InputStream snapshotEventFile;
    private final Serializer eventSerializer;

    public FileSystemSnapshotEventReader(InputStream eventFile, InputStream snapshotEventFile, Serializer eventSerializer) {
        this.eventFile = eventFile;
        this.snapshotEventFile = snapshotEventFile;
        this.eventSerializer = eventSerializer;
    }

    public DomainEventMessage readSnapshotEvent(String type, Object identifier) throws IOException {
        DomainEventMessage snapshotEvent = null;
        FileSystemSnapshotEventEntry fileSystemSnapshotEvent = this.readLastSnapshotEntry();
        if (fileSystemSnapshotEvent != null) {
            long actuallySkipped = this.eventFile.skip(fileSystemSnapshotEvent.getBytesToSkipInEventFile());
            if (actuallySkipped != fileSystemSnapshotEvent.getBytesToSkipInEventFile()) {
                logger.warn("The skip operation did not actually skip the expected amount of bytes. The event log of aggregate of type {} and identifier {} might be corrupt.", (Object)type, identifier);
            }
            snapshotEvent = fileSystemSnapshotEvent.getEventMessage();
        }
        return snapshotEvent;
    }

    private FileSystemSnapshotEventEntry readLastSnapshotEntry() throws IOException {
        FileSystemSnapshotEventEntry snapshotEvent;
        FileSystemSnapshotEventEntry lastSnapshotEvent = null;
        DataInputStream snapshotEventFileDataInputStream = new DataInputStream(this.snapshotEventFile);
        do {
            if ((snapshotEvent = this.readSnapshotEventEntry(snapshotEventFileDataInputStream)) == null) continue;
            lastSnapshotEvent = snapshotEvent;
        } while (snapshotEvent != null);
        return lastSnapshotEvent;
    }

    private FileSystemSnapshotEventEntry readSnapshotEventEntry(DataInputStream snapshotEventFileDataInputStream) throws IOException {
        FileSystemEventMessageReader snapshotEventReader = new FileSystemEventMessageReader(snapshotEventFileDataInputStream);
        try {
            long bytesToSkip = snapshotEventFileDataInputStream.readLong();
            SerializedDomainEventData snapshotEventData = snapshotEventReader.readEventMessage();
            SerializedDomainEventMessage snapshotEvent = new SerializedDomainEventMessage(snapshotEventData, this.eventSerializer);
            return new FileSystemSnapshotEventEntry(snapshotEvent, bytesToSkip);
        }
        catch (EOFException e) {
            return null;
        }
    }

    private static final class FileSystemSnapshotEventEntry {
        private final DomainEventMessage eventMessage;
        private final long bytesToSkipInEventFile;

        private FileSystemSnapshotEventEntry(DomainEventMessage eventMessage, long bytesToSkipInEventFile) {
            this.eventMessage = eventMessage;
            this.bytesToSkipInEventFile = bytesToSkipInEventFile;
        }

        public DomainEventMessage getEventMessage() {
            return this.eventMessage;
        }

        public long getBytesToSkipInEventFile() {
            return this.bytesToSkipInEventFile;
        }
    }
}

