/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.DataOutput;
import java.io.IOException;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.serializer.MessageSerializer;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;

public class FileSystemEventMessageWriter {
    private final MessageSerializer messageSerializer;
    private final DataOutput out;

    public FileSystemEventMessageWriter(DataOutput output, Serializer serializer) {
        this.out = output;
        this.messageSerializer = new MessageSerializer(serializer);
    }

    public void writeEventMessage(DomainEventMessage eventMessage) throws IOException {
        this.out.write(0);
        this.out.writeUTF(eventMessage.getIdentifier());
        this.out.writeUTF(eventMessage.getTimestamp().toString());
        this.out.writeUTF(eventMessage.getAggregateIdentifier().toString());
        this.out.writeLong(eventMessage.getSequenceNumber());
        SerializedObject<byte[]> serializedPayload = this.messageSerializer.serializePayload(eventMessage, byte[].class);
        SerializedObject<byte[]> serializedMetaData = this.messageSerializer.serializeMetaData(eventMessage, byte[].class);
        this.out.writeUTF(serializedPayload.getType().getName());
        String revision = serializedPayload.getType().getRevision();
        this.out.writeUTF(revision == null ? "" : revision);
        this.out.writeInt(serializedPayload.getData().length);
        this.out.write(serializedPayload.getData());
        this.out.writeInt(serializedMetaData.getData().length);
        this.out.write(serializedMetaData.getData());
    }
}

