/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import org.axonframework.common.io.IOUtils;
import org.axonframework.eventstore.jpa.SimpleSerializedDomainEventData;
import org.axonframework.serializer.SerializedDomainEventData;

public class FileSystemEventMessageReader
implements Closeable {
    private final DataInput in;

    public FileSystemEventMessageReader(DataInput input) {
        this.in = input;
    }

    public SerializedDomainEventData readEventMessage() throws IOException {
        this.in.readByte();
        String identifier = this.in.readUTF();
        String timestamp = this.in.readUTF();
        String aggregateIdentifier = this.in.readUTF();
        long sequenceNumber = this.in.readLong();
        String payloadType = this.in.readUTF();
        String payloadRevision = this.in.readUTF();
        byte[] payload = new byte[this.in.readInt()];
        this.in.readFully(payload);
        int metaDataSize = this.in.readInt();
        byte[] metaData = new byte[metaDataSize];
        this.in.readFully(metaData);
        return new SimpleSerializedDomainEventData<byte[]>(identifier, aggregateIdentifier, sequenceNumber, timestamp, payloadType, payloadRevision, payload, metaData);
    }

    @Override
    public void close() {
        IOUtils.closeQuietlyIfCloseable(this.in);
    }
}

