/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.eventstore.fs.FileSystemEventMessageReader;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.Serializer;
import org.axonframework.upcasting.UpcastUtils;
import org.axonframework.upcasting.UpcasterChain;

public class FileSystemBufferedReaderDomainEventStream
implements DomainEventStream,
Closeable {
    private final Queue<DomainEventMessage> next;
    private final FileSystemEventMessageReader eventMessageReader;
    private final UpcasterChain upcasterChain;
    private final Serializer serializer;

    public FileSystemBufferedReaderDomainEventStream(InputStream inputStream, Serializer serializer, UpcasterChain upcasterChain) {
        this.eventMessageReader = new FileSystemEventMessageReader(new DataInputStream(new BufferedInputStream(inputStream)));
        this.upcasterChain = upcasterChain;
        this.serializer = serializer;
        this.next = new LinkedList<DomainEventMessage>();
        this.next.addAll(this.doReadNext());
    }

    @Override
    public boolean hasNext() {
        if (this.next.isEmpty()) {
            this.next.addAll(this.doReadNext());
        }
        return !this.next.isEmpty();
    }

    @Override
    public DomainEventMessage next() {
        DomainEventMessage nextMessage = this.next.poll();
        if (this.next.isEmpty()) {
            this.next.addAll(this.doReadNext());
        }
        return nextMessage;
    }

    @Override
    public DomainEventMessage peek() {
        return this.next.peek();
    }

    private List<DomainEventMessage> doReadNext() {
        try {
            SerializedDomainEventData eventFromFile;
            List<DomainEventMessage> upcastEvents;
            while ((upcastEvents = UpcastUtils.upcastAndDeserialize(eventFromFile = this.eventMessageReader.readEventMessage(), null, this.serializer, this.upcasterChain, false)).isEmpty()) {
            }
            return upcastEvents;
        }
        catch (EOFException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new EventStoreException("An error occurred while reading from the underlying source", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.eventMessageReader.close();
    }
}

