/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.CollectionUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.HandlerDefinition;
import org.axonframework.common.annotation.MessageHandlerInvoker;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.eventhandling.annotation.EventHandler;
import org.axonframework.eventsourcing.EventSourcedEntity;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.axonframework.eventsourcing.annotation.AbstractAnnotatedAggregateRoot;
import org.axonframework.eventsourcing.annotation.AggregateIdentifier;
import org.axonframework.eventsourcing.annotation.EventSourcedMember;
import org.axonframework.eventsourcing.annotation.EventSourcingHandler;

public final class AggregateAnnotationInspector {
    private static final Map<Class<?>, AggregateAnnotationInspector> INSTANCES = new ConcurrentHashMap();
    private final Field[] childEntityFields;
    private final Field identifierField;
    private final ParameterResolverFactory parameterResolverFactory;

    public static AggregateAnnotationInspector getInspector(Class<?> entityType, ParameterResolverFactory parameterResolverFactory) {
        AggregateAnnotationInspector inspector = INSTANCES.get(entityType);
        if (inspector == null || !parameterResolverFactory.equals(inspector.parameterResolverFactory)) {
            inspector = new AggregateAnnotationInspector(entityType, parameterResolverFactory);
            INSTANCES.put(entityType, inspector);
        }
        return inspector;
    }

    private AggregateAnnotationInspector(Class<?> entityType, ParameterResolverFactory parameterResolverFactory) {
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : ReflectionUtils.fieldsOf(entityType)) {
            if (!field.isAnnotationPresent(EventSourcedMember.class)) continue;
            annotatedFields.add(field);
        }
        this.childEntityFields = annotatedFields.toArray(new Field[annotatedFields.size()]);
        this.identifierField = AbstractAnnotatedAggregateRoot.class.isAssignableFrom(entityType) ? this.locateIdentifierField(entityType) : null;
        this.parameterResolverFactory = parameterResolverFactory;
    }

    public MessageHandlerInvoker createEventHandlerInvoker(Object instance) {
        return new MessageHandlerInvoker(instance, this.parameterResolverFactory, false, AggregatedEventSourcingHandlerDefinition.INSTANCE);
    }

    public Collection<EventSourcedEntity> getChildEntities(Object instance) {
        if (this.childEntityFields.length == 0 || instance == null) {
            return null;
        }
        ArrayList<EventSourcedEntity> children = new ArrayList<EventSourcedEntity>();
        for (Field childEntityField : this.childEntityFields) {
            Object fieldValue = ReflectionUtils.getFieldValue(childEntityField, instance);
            if (EventSourcedEntity.class.isInstance(fieldValue)) {
                children.add((EventSourcedEntity)fieldValue);
                continue;
            }
            if (Iterable.class.isInstance(fieldValue)) {
                Iterable iterable = (Iterable)fieldValue;
                children.addAll(CollectionUtils.filterByType(iterable, EventSourcedEntity.class));
                continue;
            }
            if (Map.class.isInstance(fieldValue)) {
                Map map = (Map)fieldValue;
                children.addAll(CollectionUtils.filterByType(map.keySet(), EventSourcedEntity.class));
                children.addAll(CollectionUtils.filterByType(map.values(), EventSourcedEntity.class));
                continue;
            }
            if (fieldValue == null || !childEntityField.getType().isArray()) continue;
            for (int i = 0; i < Array.getLength(fieldValue); ++i) {
                Object value = Array.get(fieldValue, i);
                if (!EventSourcedEntity.class.isInstance(value)) continue;
                children.add((EventSourcedEntity)value);
            }
        }
        return children;
    }

    public <I> I getIdentifier(AbstractAnnotatedAggregateRoot<I> aggregateRoot) {
        if (this.identifierField == null) {
            throw new IncompatibleAggregateException(String.format("The aggregate class [%s] does not specify an Identifier. Ensure that the field containing the aggregate identifier is annotated with @AggregateIdentifier.", aggregateRoot.getClass().getSimpleName()));
        }
        return (I)ReflectionUtils.getFieldValue(this.identifierField, aggregateRoot);
    }

    private Field locateIdentifierField(Class<? extends AbstractAnnotatedAggregateRoot> aggregateRootType) {
        for (Field candidate : ReflectionUtils.fieldsOf(aggregateRootType)) {
            if (!this.containsIdentifierAnnotation(candidate.getAnnotations())) continue;
            ReflectionUtils.ensureAccessible(candidate);
            return candidate;
        }
        return null;
    }

    private boolean containsIdentifierAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof AggregateIdentifier) {
                return true;
            }
            if (!((Object)annotation).toString().startsWith("@javax.persistence.Id(")) continue;
            return true;
        }
        return false;
    }

    private static class AggregatedEventSourcingHandlerDefinition
    implements HandlerDefinition<Method> {
        private static final AggregatedEventSourcingHandlerDefinition INSTANCE = new AggregatedEventSourcingHandlerDefinition();

        private AggregatedEventSourcingHandlerDefinition() {
        }

        @Override
        public boolean isMessageHandler(Method member) {
            return member.isAnnotationPresent(EventSourcingHandler.class) || member.isAnnotationPresent(EventHandler.class);
        }

        @Override
        public Class<?> resolvePayloadFor(Method member) {
            EventSourcingHandler handlerAnnotation = member.getAnnotation(EventSourcingHandler.class);
            Class<?> definedPayload = null;
            if (handlerAnnotation != null) {
                definedPayload = handlerAnnotation.eventType();
            } else {
                EventHandler legacyAnnotation = member.getAnnotation(EventHandler.class);
                if (legacyAnnotation != null) {
                    definedPayload = legacyAnnotation.eventType();
                }
            }
            return definedPayload == Void.class ? null : definedPayload;
        }

        public String toString() {
            return "AnnotatedEventSourcingMemberDefinition";
        }
    }
}

