/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.annotation;

import java.util.Collection;
import org.axonframework.common.annotation.MessageHandlerInvoker;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractEventSourcedEntity;
import org.axonframework.eventsourcing.EventSourcedEntity;
import org.axonframework.eventsourcing.annotation.AbstractAnnotatedAggregateRoot;
import org.axonframework.eventsourcing.annotation.AggregateAnnotationInspector;

public abstract class AbstractAnnotatedEntity
extends AbstractEventSourcedEntity {
    private transient AggregateAnnotationInspector inspector;
    private transient MessageHandlerInvoker eventHandlerInvoker;

    protected AbstractAnnotatedEntity() {
    }

    @Override
    protected void handle(DomainEventMessage event) {
        this.ensureInspectorInitialized();
        this.ensureInvokerInitialized();
        this.eventHandlerInvoker.invokeHandlerMethod(event);
    }

    protected Collection<EventSourcedEntity> getChildEntities() {
        this.ensureInspectorInitialized();
        return this.inspector.getChildEntities(this);
    }

    private void ensureInvokerInitialized() {
        if (this.eventHandlerInvoker == null) {
            this.eventHandlerInvoker = this.inspector.createEventHandlerInvoker(this);
        }
    }

    private void ensureInspectorInitialized() {
        if (this.inspector == null) {
            ParameterResolverFactory parameterResolverFactory = this.createParameterResolverFactory();
            this.inspector = AggregateAnnotationInspector.getInspector(this.getClass(), parameterResolverFactory);
        }
    }

    protected ParameterResolverFactory createParameterResolverFactory() {
        return ((AbstractAnnotatedAggregateRoot)this.getAggregateRoot()).createParameterResolverFactory();
    }
}

