/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.annotation;

import java.util.Collection;
import javax.persistence.MappedSuperclass;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.MessageHandlerInvoker;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractEventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcedEntity;
import org.axonframework.eventsourcing.annotation.AggregateAnnotationInspector;
import org.axonframework.unitofwork.CurrentUnitOfWork;

@MappedSuperclass
public abstract class AbstractAnnotatedAggregateRoot<I>
extends AbstractEventSourcedAggregateRoot<I> {
    private static final long serialVersionUID = -1206026570158467937L;
    private transient MessageHandlerInvoker eventHandlerInvoker;
    private transient AggregateAnnotationInspector inspector;
    private transient ParameterResolverFactory parameterResolverFactory;

    @Override
    protected void handle(DomainEventMessage event) {
        this.ensureInspectorInitialized();
        this.ensureInvokerInitialized();
        this.eventHandlerInvoker.invokeHandlerMethod(event);
    }

    @Override
    public I getIdentifier() {
        this.ensureInspectorInitialized();
        return this.inspector.getIdentifier(this);
    }

    protected Collection<EventSourcedEntity> getChildEntities() {
        this.ensureInspectorInitialized();
        return this.inspector.getChildEntities(this);
    }

    private void ensureInvokerInitialized() {
        if (this.eventHandlerInvoker == null) {
            this.ensureInspectorInitialized();
            this.eventHandlerInvoker = this.inspector.createEventHandlerInvoker(this);
        }
    }

    private void ensureInspectorInitialized() {
        if (this.inspector == null) {
            Class<?> aggregateType = this.getClass();
            this.inspector = AggregateAnnotationInspector.getInspector(aggregateType, this.createParameterResolverFactory());
        }
    }

    protected ParameterResolverFactory createParameterResolverFactory() {
        if (this.parameterResolverFactory == null && CurrentUnitOfWork.isStarted()) {
            this.parameterResolverFactory = (ParameterResolverFactory)CurrentUnitOfWork.get().getResource(ParameterResolverFactory.class.getName());
        }
        if (this.parameterResolverFactory == null) {
            this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(this.getClass());
        }
        return this.parameterResolverFactory;
    }

    public void registerParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
    }
}

