/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.MultiParameterResolverFactory;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.annotation.SpringBeanParameterResolverFactory;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.axonframework.eventsourcing.annotation.AbstractAnnotatedAggregateRoot;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringPrototypeAggregateFactory<T extends EventSourcedAggregateRoot>
extends AbstractAggregateFactory<T>
implements InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private String prototypeBeanName;
    private String typeIdentifier;
    private ApplicationContext applicationContext;
    private String beanName;
    private Class<?> aggregateType;
    private ParameterResolverFactory parameterResolverFactory;

    @Override
    public T doCreateAggregate(Object aggregateIdentifier, DomainEventMessage firstEvent) {
        return (T)((EventSourcedAggregateRoot)this.applicationContext.getBean(this.prototypeBeanName));
    }

    @Override
    protected T postProcessInstance(T aggregate) {
        this.applicationContext.getAutowireCapableBeanFactory().configureBean(aggregate, this.prototypeBeanName);
        if (aggregate instanceof AbstractAnnotatedAggregateRoot) {
            ((AbstractAnnotatedAggregateRoot)aggregate).registerParameterResolverFactory(this.parameterResolverFactory);
        }
        return aggregate;
    }

    @Override
    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public Class<T> getAggregateType() {
        if (this.aggregateType == null) {
            this.aggregateType = this.applicationContext.getType(this.prototypeBeanName);
        }
        return this.aggregateType;
    }

    @Required
    public void setPrototypeBeanName(String prototypeBeanName) {
        this.prototypeBeanName = prototypeBeanName;
    }

    public void setTypeIdentifier(String typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public void setParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.typeIdentifier == null) {
            this.typeIdentifier = this.prototypeBeanName;
        }
        if (!this.applicationContext.isPrototype(this.prototypeBeanName)) {
            throw new IncompatibleAggregateException(String.format("Cannot initialize repository '%s'. The bean with name '%s' does not have the 'prototype' scope.", this.beanName, this.prototypeBeanName));
        }
        this.aggregateType = this.applicationContext.getType(this.prototypeBeanName);
        if (!EventSourcedAggregateRoot.class.isAssignableFrom(this.aggregateType)) {
            throw new IncompatibleAggregateException(String.format("Cannot initialize repository '%s'. The bean with name '%s' does not extend from EventSourcingAggregateRoot.", this.beanName, this.prototypeBeanName));
        }
        if (this.parameterResolverFactory == null) {
            SpringBeanParameterResolverFactory springBeanParameterResolverFactory = new SpringBeanParameterResolverFactory();
            springBeanParameterResolverFactory.setApplicationContext(this.applicationContext);
            this.parameterResolverFactory = MultiParameterResolverFactory.ordered(ClasspathParameterResolverFactory.forClass(this.aggregateType), springBeanParameterResolverFactory);
        }
    }
}

