/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.eventstore.EventStore;
import org.axonframework.repository.GenericJpaRepository;
import org.axonframework.repository.LockManager;
import org.axonframework.repository.NullLockManager;

public class HybridJpaRepository<T extends AggregateRoot>
extends GenericJpaRepository<T> {
    private EventStore eventStore;
    private final String aggregateTypeIdentifier;

    public HybridJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType) {
        this(entityManagerProvider, aggregateType, aggregateType.getSimpleName());
    }

    public HybridJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, String aggregateTypeIdentifier) {
        this(entityManagerProvider, aggregateType, aggregateTypeIdentifier, new NullLockManager());
    }

    public HybridJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, LockManager lockManager) {
        this(entityManagerProvider, aggregateType, aggregateType.getSimpleName(), lockManager);
    }

    public HybridJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, String aggregateTypeIdentifier, LockManager lockManager) {
        super(entityManagerProvider, aggregateType, lockManager);
        this.aggregateTypeIdentifier = aggregateTypeIdentifier;
    }

    @Override
    protected void doDeleteWithLock(T aggregate) {
        if (this.eventStore != null) {
            this.eventStore.appendEvents(this.getTypeIdentifier(), aggregate.getUncommittedEvents());
        }
        super.doDeleteWithLock(aggregate);
    }

    @Override
    protected void doSaveWithLock(T aggregate) {
        if (this.eventStore != null) {
            this.eventStore.appendEvents(this.getTypeIdentifier(), aggregate.getUncommittedEvents());
        }
        super.doSaveWithLock(aggregate);
    }

    protected String getTypeIdentifier() {
        return this.aggregateTypeIdentifier;
    }

    public void setEventStore(EventStore eventStore) {
        this.eventStore = eventStore;
    }
}

