/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.IncompatibleAggregateException;

public class GenericAggregateFactory<T extends EventSourcedAggregateRoot>
extends AbstractAggregateFactory<T> {
    private final String typeIdentifier;
    private final Class<T> aggregateType;
    private final Constructor<T> constructor;

    public GenericAggregateFactory(Class<T> aggregateType) {
        this(aggregateType, null);
    }

    public GenericAggregateFactory(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory) {
        super(parameterResolverFactory);
        Assert.isTrue(EventSourcedAggregateRoot.class.isAssignableFrom(aggregateType), "The given aggregateType must be a subtype of EventSourcedAggregateRoot");
        Assert.isFalse(Modifier.isAbstract(aggregateType.getModifiers()), "Given aggregateType may not be abstract");
        this.aggregateType = aggregateType;
        this.typeIdentifier = aggregateType.getSimpleName();
        try {
            this.constructor = ReflectionUtils.ensureAccessible(aggregateType.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate [%s] doesn't provide a no-arg constructor.", aggregateType.getSimpleName()), e);
        }
    }

    @Override
    protected T doCreateAggregate(Object aggregateIdentifier, DomainEventMessage firstEvent) {
        try {
            return (T)((EventSourcedAggregateRoot)this.constructor.newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate [%s] does not have a suitable no-arg constructor.", this.aggregateType.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate no-arg constructor of the aggregate [%s] is not accessible. Please ensure that the constructor is public or that the Security Manager allows access through reflection.", this.aggregateType.getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IncompatibleAggregateException(String.format("The no-arg constructor of [%s] threw an exception on invocation.", this.aggregateType.getSimpleName()), e);
        }
    }

    @Override
    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public Class<T> getAggregateType() {
        return this.aggregateType;
    }
}

