/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.axonframework.common.Assert;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.ConflictResolver;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventStreamDecorator;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.SnapshotterTrigger;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStreamNotFoundException;
import org.axonframework.repository.AggregateNotFoundException;
import org.axonframework.repository.LockManager;
import org.axonframework.repository.LockingRepository;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class EventSourcingRepository<T extends EventSourcedAggregateRoot>
extends LockingRepository<T> {
    private final EventStore eventStore;
    private ConflictResolver conflictResolver;
    private final Deque<EventStreamDecorator> eventStreamDecorators = new ArrayDeque<EventStreamDecorator>();
    private final AggregateFactory<T> aggregateFactory;

    public EventSourcingRepository(Class<T> aggregateType, EventStore eventStore) {
        this(new GenericAggregateFactory<T>(aggregateType), eventStore);
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore) {
        super(aggregateFactory.getAggregateType());
        Assert.notNull(eventStore, "eventStore may not be null");
        this.aggregateFactory = aggregateFactory;
        this.eventStore = eventStore;
    }

    public EventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockManager lockManager) {
        super(aggregateFactory.getAggregateType(), lockManager);
        Assert.notNull(eventStore, "eventStore may not be null");
        this.eventStore = eventStore;
        this.aggregateFactory = aggregateFactory;
    }

    public EventSourcingRepository(Class<T> aggregateType, EventStore eventStore, LockManager lockManager) {
        this(new GenericAggregateFactory<T>(aggregateType), eventStore, lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSaveWithLock(T aggregate) {
        DomainEventStream eventStream = aggregate.getUncommittedEvents();
        try {
            Iterator<EventStreamDecorator> iterator = this.eventStreamDecorators.descendingIterator();
            while (iterator.hasNext()) {
                eventStream = iterator.next().decorateForAppend(this.getTypeIdentifier(), (EventSourcedAggregateRoot)aggregate, eventStream);
            }
            this.eventStore.appendEvents(this.getTypeIdentifier(), eventStream);
        }
        finally {
            IOUtils.closeQuietlyIfCloseable(eventStream);
        }
    }

    @Override
    protected void doDeleteWithLock(T aggregate) {
        this.doSaveWithLock(aggregate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T doLoad(Object aggregateIdentifier, Long expectedVersion) {
        T t;
        DomainEventStream events = null;
        DomainEventStream originalStream = null;
        try {
            try {
                events = this.eventStore.readEvents(this.getTypeIdentifier(), aggregateIdentifier);
            }
            catch (EventStreamNotFoundException e) {
                throw new AggregateNotFoundException(aggregateIdentifier, "The aggregate was not found", e);
            }
            originalStream = events;
            for (EventStreamDecorator decorator : this.eventStreamDecorators) {
                events = decorator.decorateForRead(this.getTypeIdentifier(), aggregateIdentifier, events);
            }
            T aggregate = this.aggregateFactory.createAggregate(aggregateIdentifier, events.peek());
            ArrayList unseenEvents = new ArrayList();
            aggregate.initializeState(new CapturingEventStream(events, unseenEvents, expectedVersion));
            if (aggregate.isDeleted()) {
                throw new AggregateDeletedException(aggregateIdentifier);
            }
            CurrentUnitOfWork.get().registerListener(new ConflictResolvingListener(this, (EventSourcedAggregateRoot)aggregate, unseenEvents));
            t = aggregate;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietlyIfCloseable(events);
            IOUtils.closeQuietlyIfCloseable(originalStream);
            throw throwable;
        }
        IOUtils.closeQuietlyIfCloseable(events);
        IOUtils.closeQuietlyIfCloseable(originalStream);
        return t;
    }

    public AggregateFactory<T> getAggregateFactory() {
        return this.aggregateFactory;
    }

    protected void resolveConflicts(T aggregate, DomainEventStream unseenEvents) {
        CurrentUnitOfWork.get().registerListener(new ConflictResolvingListener(this, (EventSourcedAggregateRoot)aggregate, this.asList(unseenEvents)));
    }

    private List<DomainEventMessage> asList(DomainEventStream domainEventStream) {
        ArrayList<DomainEventMessage> unseenEvents = new ArrayList<DomainEventMessage>();
        while (domainEventStream.hasNext()) {
            unseenEvents.add(domainEventStream.next());
        }
        return unseenEvents;
    }

    public String getTypeIdentifier() {
        if (this.aggregateFactory == null) {
            throw new IllegalStateException("Either an aggregate factory must be configured (recommended), or the getTypeIdentifier() method must be overridden.");
        }
        return this.aggregateFactory.getTypeIdentifier();
    }

    @Override
    protected void validateOnLoad(T aggregate, Long expectedVersion) {
        if (this.conflictResolver == null) {
            super.validateOnLoad(aggregate, expectedVersion);
        }
    }

    public void setEventStreamDecorators(List<? extends EventStreamDecorator> eventProcessors) {
        this.eventStreamDecorators.addAll(eventProcessors);
    }

    public void setSnapshotterTrigger(SnapshotterTrigger snapshotterTrigger) {
        this.eventStreamDecorators.add(snapshotterTrigger);
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    private static final class CapturingEventStream
    implements DomainEventStream,
    Closeable {
        private final DomainEventStream eventStream;
        private final List<DomainEventMessage> unseenEvents;
        private final Long expectedVersion;

        private CapturingEventStream(DomainEventStream events, List<DomainEventMessage> unseenEvents, Long expectedVersion) {
            this.eventStream = events;
            this.unseenEvents = unseenEvents;
            this.expectedVersion = expectedVersion;
        }

        @Override
        public boolean hasNext() {
            return this.eventStream.hasNext();
        }

        @Override
        public DomainEventMessage next() {
            DomainEventMessage next = this.eventStream.next();
            if (this.expectedVersion != null && next.getSequenceNumber() > this.expectedVersion) {
                this.unseenEvents.add(next);
            }
            return next;
        }

        @Override
        public DomainEventMessage peek() {
            return this.eventStream.peek();
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietlyIfCloseable(this.eventStream);
        }
    }

    private static final class ConflictResolvingListener
    extends UnitOfWorkListenerAdapter {
        private final T aggregate;
        private final List<DomainEventMessage> unseenEvents;
        final /* synthetic */ EventSourcingRepository this$0;

        private ConflictResolvingListener(T aggregate, List<DomainEventMessage> unseenEvents) {
            this.this$0 = var1_1;
            this.aggregate = aggregate;
            this.unseenEvents = unseenEvents;
        }

        @Override
        public void onPrepareCommit(UnitOfWork unitOfWork, Set<AggregateRoot> aggregateRoots, List<EventMessage> events) {
            if (this.hasPotentialConflicts()) {
                this.this$0.conflictResolver.resolveConflicts(this.this$0.asList(this.aggregate.getUncommittedEvents()), this.unseenEvents);
            }
        }

        private boolean hasPotentialConflicts() {
            return this.aggregate.getUncommittedEventCount() > 0 && this.aggregate.getVersion() != null && !this.unseenEvents.isEmpty();
        }
    }
}

