/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import org.axonframework.cache.Cache;
import org.axonframework.cache.NoCache;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.PartialStreamSupport;
import org.axonframework.repository.LockManager;
import org.axonframework.repository.PessimisticLockManager;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class CachingEventSourcingRepository<T extends EventSourcedAggregateRoot>
extends EventSourcingRepository<T> {
    private Cache cache = NoCache.INSTANCE;
    private final boolean hasEventStorePartialReadSupport;
    private final PartialStreamSupport eventStore;

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore) {
        this(aggregateFactory, eventStore, (LockManager)new PessimisticLockManager());
    }

    public CachingEventSourcingRepository(AggregateFactory<T> aggregateFactory, EventStore eventStore, LockManager lockManager) {
        super(aggregateFactory, eventStore, lockManager);
        this.hasEventStorePartialReadSupport = eventStore instanceof PartialStreamSupport;
        this.eventStore = eventStore instanceof PartialStreamSupport ? (PartialStreamSupport)((Object)eventStore) : null;
    }

    @Override
    public void add(T aggregate) {
        CurrentUnitOfWork.get().registerListener(new CacheClearingUnitOfWorkListener(aggregate.getIdentifier()));
        super.add(aggregate);
    }

    @Override
    protected void postSave(T aggregate) {
        super.postSave(aggregate);
        this.cache.put(aggregate.getIdentifier(), aggregate);
    }

    @Override
    protected void postDelete(T aggregate) {
        super.postDelete(aggregate);
        this.cache.put(aggregate.getIdentifier(), aggregate);
    }

    @Override
    public T doLoad(Object aggregateIdentifier, Long expectedVersion) {
        AggregateRoot aggregate = (EventSourcedAggregateRoot)this.cache.get(aggregateIdentifier);
        if (aggregate == null || !this.hasEventStorePartialReadSupport && !this.hasExpectedVersion(expectedVersion, aggregate.getVersion())) {
            aggregate = super.doLoad(aggregateIdentifier, expectedVersion);
        } else if (!this.hasExpectedVersion(expectedVersion, aggregate.getVersion())) {
            this.resolveConflicts(aggregate, this.eventStore.readEvents(this.getTypeIdentifier(), aggregateIdentifier, expectedVersion + 1L, aggregate.getVersion()));
        } else if (aggregate.isDeleted()) {
            throw new AggregateDeletedException(aggregateIdentifier);
        }
        CurrentUnitOfWork.get().registerListener(new CacheClearingUnitOfWorkListener(aggregateIdentifier));
        return (T)aggregate;
    }

    private boolean hasExpectedVersion(Long expectedVersion, Long actualVersion) {
        return expectedVersion == null || actualVersion != null && actualVersion.equals(expectedVersion);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    private class CacheClearingUnitOfWorkListener
    extends UnitOfWorkListenerAdapter {
        private final Object identifier;

        public CacheClearingUnitOfWorkListener(Object identifier) {
            this.identifier = identifier;
        }

        @Override
        public void onRollback(UnitOfWork unitOfWork, Throwable failureCause) {
            CachingEventSourcingRepository.this.cache.remove(this.identifier);
        }
    }
}

