/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import javax.annotation.PostConstruct;
import org.axonframework.common.Assert;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.SchedulingException;
import org.axonframework.eventhandling.scheduling.quartz.FireEventJob;
import org.axonframework.eventhandling.scheduling.quartz.QuartzScheduleToken;
import org.axonframework.unitofwork.DefaultUnitOfWorkFactory;
import org.axonframework.unitofwork.TransactionManager;
import org.axonframework.unitofwork.UnitOfWorkFactory;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzEventScheduler
implements EventScheduler {
    private static final Logger logger = LoggerFactory.getLogger(QuartzEventScheduler.class);
    private static final String JOB_NAME_PREFIX = "event-";
    private static final String DEFAULT_GROUP_NAME = "AxonFramework-Events";
    private String groupIdentifier = "AxonFramework-Events";
    private Scheduler scheduler;
    private EventBus eventBus;
    private volatile boolean initialized;
    private UnitOfWorkFactory unitOfWorkFactory = new DefaultUnitOfWorkFactory();

    @Override
    public ScheduleToken schedule(DateTime triggerDateTime, Object event) {
        Assert.state(this.initialized, "Scheduler is not yet initialized");
        EventMessage eventMessage = GenericEventMessage.asEventMessage(event);
        String jobIdentifier = JOB_NAME_PREFIX + eventMessage.getIdentifier();
        QuartzScheduleToken tr = new QuartzScheduleToken(jobIdentifier, this.groupIdentifier);
        try {
            JobDetail jobDetail = this.buildJobDetail(eventMessage, new JobKey(jobIdentifier, this.groupIdentifier));
            this.scheduler.scheduleJob(jobDetail, this.buildTrigger(triggerDateTime, jobDetail.getKey()));
        }
        catch (SchedulerException e) {
            throw new SchedulingException("An error occurred while setting a timer for a saga", e);
        }
        return tr;
    }

    protected JobDetail buildJobDetail(EventMessage event, JobKey jobKey) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(FireEventJob.EVENT_KEY, (Object)event);
        return JobBuilder.newJob(FireEventJob.class).withDescription(event.getPayloadType().getName()).withIdentity(jobKey).usingJobData(jobDataMap).build();
    }

    protected Trigger buildTrigger(DateTime triggerDateTime, JobKey jobKey) {
        return TriggerBuilder.newTrigger().forJob(jobKey).startAt(triggerDateTime.toDate()).build();
    }

    @Override
    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        return this.schedule(new DateTime().plus((ReadableDuration)triggerDuration), event);
    }

    @Override
    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!QuartzScheduleToken.class.isInstance(scheduleToken)) {
            throw new IllegalArgumentException("The given ScheduleToken was not provided by this scheduler.");
        }
        Assert.state(this.initialized, "Scheduler is not yet initialized");
        QuartzScheduleToken reference = (QuartzScheduleToken)scheduleToken;
        try {
            if (!this.scheduler.deleteJob(JobKey.jobKey((String)reference.getJobIdentifier(), (String)reference.getGroupIdentifier()))) {
                logger.warn("The job belonging to this token could not be deleted.");
            }
        }
        catch (SchedulerException e) {
            throw new SchedulingException("An error occurred while cancelling a timer for a saga", e);
        }
    }

    @PostConstruct
    public void initialize() throws SchedulerException {
        Assert.notNull(this.scheduler, "A Scheduler must be provided.");
        Assert.notNull(this.eventBus, "An EventBus must be provided.");
        this.scheduler.getContext().put(FireEventJob.EVENT_BUS_KEY, (Object)this.eventBus);
        this.scheduler.getContext().put(FireEventJob.UNIT_OF_WORK_FACTORY_KEY, (Object)this.unitOfWorkFactory);
        this.initialized = true;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setGroupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.unitOfWorkFactory = new DefaultUnitOfWorkFactory(transactionManager);
    }

    public void setUnitOfWorkFactory(UnitOfWorkFactory unitOfWorkFactory) {
        this.unitOfWorkFactory = unitOfWorkFactory;
    }
}

