/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.unitofwork.TransactionManager;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireEventJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(FireEventJob.class);
    public static final String EVENT_KEY = EventMessage.class.getName();
    public static final String EVENT_BUS_KEY = EventBus.class.getName();
    public static final String UNIT_OF_WORK_FACTORY_KEY = TransactionManager.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Starting job to publish a scheduled event");
        Object event = context.getJobDetail().getJobDataMap().get((Object)EVENT_KEY);
        EventMessage<?> eventMessage = this.createMessage(event);
        try {
            EventBus eventBus = (EventBus)context.getScheduler().getContext().get((Object)EVENT_BUS_KEY);
            UnitOfWorkFactory unitOfWorkFactory = (UnitOfWorkFactory)context.getScheduler().getContext().get((Object)UNIT_OF_WORK_FACTORY_KEY);
            UnitOfWork uow = unitOfWorkFactory.createUnitOfWork();
            try {
                uow.publishEvent(eventMessage, eventBus);
            }
            finally {
                uow.commit();
            }
            if (logger.isInfoEnabled()) {
                logger.info("Job successfully executed. Scheduled Event [{}] has been published.", (Object)eventMessage.getPayloadType().getSimpleName());
            }
        }
        catch (Exception e) {
            logger.warn("Exception occurred while publishing scheduled event [{}]", (Object)eventMessage.getPayloadType().getSimpleName());
            throw new JobExecutionException((Throwable)e);
        }
    }

    private EventMessage<?> createMessage(Object event) {
        GenericEventMessage<Object> eventMessage = event instanceof EventMessage ? new GenericEventMessage(((EventMessage)event).getPayload(), ((EventMessage)event).getMetaData()) : new GenericEventMessage<Object>(event);
        return eventMessage;
    }
}

