/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.java;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.Assert;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.domain.IdentifierFactory;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.java.SimpleScheduleToken;
import org.axonframework.unitofwork.DefaultUnitOfWorkFactory;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkFactory;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventScheduler
implements EventScheduler {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEventScheduler.class);
    private final ScheduledExecutorService executorService;
    private final EventBus eventBus;
    private final UnitOfWorkFactory unitOfWorkFactory;
    private final Map<String, Future<?>> tokens = new ConcurrentHashMap();

    public SimpleEventScheduler(ScheduledExecutorService executorService, EventBus eventBus) {
        this(executorService, eventBus, new DefaultUnitOfWorkFactory());
    }

    public SimpleEventScheduler(ScheduledExecutorService executorService, EventBus eventBus, UnitOfWorkFactory unitOfWorkFactory) {
        Assert.notNull(executorService, "executorService may not be null");
        Assert.notNull(eventBus, "eventBus may not be null");
        Assert.notNull(unitOfWorkFactory, "unitOfWorkFactory may not be null");
        this.executorService = executorService;
        this.eventBus = eventBus;
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    @Override
    public ScheduleToken schedule(DateTime triggerDateTime, Object event) {
        return this.schedule(new Duration(null, (ReadableInstant)triggerDateTime), event);
    }

    @Override
    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        String tokenId = IdentifierFactory.getInstance().generateIdentifier();
        ScheduledFuture<?> future = this.executorService.schedule(new PublishEventTask(event, tokenId), triggerDuration.getMillis(), TimeUnit.MILLISECONDS);
        this.tokens.put(tokenId, future);
        return new SimpleScheduleToken(tokenId);
    }

    @Override
    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!SimpleScheduleToken.class.isInstance(scheduleToken)) {
            throw new IllegalArgumentException("The given ScheduleToken was not provided by this scheduler.");
        }
        Future<?> future = this.tokens.remove(((SimpleScheduleToken)scheduleToken).getTokenId());
        if (future != null) {
            future.cancel(false);
        }
    }

    private class PublishEventTask
    implements Runnable {
        private final Object event;
        private final String tokenId;

        public PublishEventTask(Object event, String tokenId) {
            this.event = event;
            this.tokenId = tokenId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventMessage<?> eventMessage = this.createMessage();
            if (logger.isInfoEnabled()) {
                logger.info("Triggered the publication of event [{}]", (Object)eventMessage.getPayloadType().getSimpleName());
            }
            UnitOfWork unitOfWork = SimpleEventScheduler.this.unitOfWorkFactory.createUnitOfWork();
            try {
                unitOfWork.publishEvent(eventMessage, SimpleEventScheduler.this.eventBus);
                unitOfWork.commit();
            }
            finally {
                SimpleEventScheduler.this.tokens.remove(this.tokenId);
            }
        }

        private EventMessage<?> createMessage() {
            GenericEventMessage<Object> eventMessage = this.event instanceof EventMessage ? new GenericEventMessage(((EventMessage)this.event).getPayload(), ((EventMessage)this.event).getMetaData()) : new GenericEventMessage<Object>(this.event);
            return eventMessage;
        }
    }
}

