/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotation;

import org.axonframework.common.Priority;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.Message;
import org.axonframework.eventhandling.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.eventhandling.annotation.Timestamp;
import org.joda.time.DateTime;

@Priority(value=0x3FFFFFFF)
public final class TimestampParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<Timestamp, DateTime> {
    private final ParameterResolver<DateTime> resolver = new TimestampParameterResolver();

    public TimestampParameterResolverFactory() {
        super(Timestamp.class, DateTime.class);
    }

    @Override
    protected ParameterResolver<DateTime> getResolver() {
        return this.resolver;
    }

    static class TimestampParameterResolver
    implements ParameterResolver<DateTime> {
        TimestampParameterResolver() {
        }

        @Override
        public DateTime resolveParameterValue(Message message) {
            if (message instanceof EventMessage) {
                return ((EventMessage)message).getTimestamp();
            }
            return null;
        }

        @Override
        public boolean matches(Message message) {
            return message instanceof EventMessage;
        }
    }
}

