/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotation;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.axonframework.common.Subscribable;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.MessageHandlerInvoker;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.annotation.AnnotatedEventHandlerDefinition;
import org.axonframework.eventhandling.replay.ReplayAware;

public class AnnotationEventListenerAdapter
implements Subscribable,
EventListenerProxy,
ReplayAware {
    private final MessageHandlerInvoker invoker;
    private final EventBus eventBus;
    private final ReplayAware replayAware;
    private final Class<?> listenerType;

    public static AnnotationEventListenerAdapter subscribe(Object annotatedEventListener, EventBus eventBus) {
        AnnotationEventListenerAdapter adapter = new AnnotationEventListenerAdapter(annotatedEventListener);
        eventBus.subscribe(adapter);
        return adapter;
    }

    public AnnotationEventListenerAdapter(Object annotatedEventListener) {
        this(annotatedEventListener, ClasspathParameterResolverFactory.forClass(annotatedEventListener.getClass()));
    }

    public AnnotationEventListenerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory) {
        this.invoker = new MessageHandlerInvoker(annotatedEventListener, parameterResolverFactory, false, AnnotatedEventHandlerDefinition.INSTANCE);
        this.listenerType = annotatedEventListener.getClass();
        this.replayAware = annotatedEventListener instanceof ReplayAware ? (ReplayAware)annotatedEventListener : new NoOpReplayAware();
        this.eventBus = null;
    }

    @Deprecated
    public AnnotationEventListenerAdapter(Object annotatedEventListener, EventBus eventBus) {
        ParameterResolverFactory factory = ClasspathParameterResolverFactory.forClass(annotatedEventListener.getClass());
        this.invoker = new MessageHandlerInvoker(annotatedEventListener, factory, false, AnnotatedEventHandlerDefinition.INSTANCE);
        this.listenerType = annotatedEventListener.getClass();
        this.eventBus = eventBus;
        this.replayAware = annotatedEventListener instanceof ReplayAware ? (ReplayAware)annotatedEventListener : new NoOpReplayAware();
    }

    @Override
    public void handle(EventMessage event) {
        this.invoker.invokeHandlerMethod(event);
    }

    @Override
    @PreDestroy
    @Deprecated
    public void unsubscribe() {
        if (this.eventBus != null) {
            this.eventBus.unsubscribe(this);
        }
    }

    @Override
    @PostConstruct
    @Deprecated
    public void subscribe() {
        if (this.eventBus != null) {
            this.eventBus.subscribe(this);
        }
    }

    @Override
    public Class<?> getTargetType() {
        return this.listenerType;
    }

    @Override
    public void beforeReplay() {
        this.replayAware.beforeReplay();
    }

    @Override
    public void afterReplay() {
        this.replayAware.afterReplay();
    }

    @Override
    public void onReplayFailed(Throwable cause) {
        this.replayAware.onReplayFailed(cause);
    }

    private static final class NoOpReplayAware
    implements ReplayAware {
        private NoOpReplayAware() {
        }

        @Override
        public void beforeReplay() {
        }

        @Override
        public void afterReplay() {
        }

        @Override
        public void onReplayFailed(Throwable cause) {
        }
    }
}

