/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import java.util.Map;
import org.axonframework.correlation.CorrelationDataHolder;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.unitofwork.CurrentUnitOfWork;

public class EventTemplate {
    private final EventBus eventBus;
    private final MetaData additionalMetaData;

    public EventTemplate(EventBus eventBus) {
        this(eventBus, Collections.emptyMap());
    }

    public EventTemplate(EventBus eventBus, Map<String, ?> additionalMetaData) {
        this.eventBus = eventBus;
        this.additionalMetaData = MetaData.from(additionalMetaData);
    }

    public void publishEvent(Object payload) {
        this.doPublish(this.createEventMessage(payload));
    }

    public void publishEvent(Object payload, Map<String, ?> metaData) {
        this.doPublish(this.createEventMessage(payload).andMetaData(metaData));
    }

    private void doPublish(EventMessage<?> message) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().publishEvent(message, this.eventBus);
        } else {
            this.eventBus.publish(message);
        }
    }

    private EventMessage<Object> createEventMessage(Object payload) {
        EventMessage eventMessage = GenericEventMessage.asEventMessage(payload);
        return eventMessage.andMetaData(CorrelationDataHolder.getCorrelationData()).andMetaData(eventMessage.getMetaData()).andMetaData(this.additionalMetaData);
    }
}

