/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventProcessingMonitor;
import org.axonframework.eventhandling.EventProcessingMonitorSupport;

public class EventProcessingMonitorCollection
implements EventProcessingMonitor,
EventProcessingMonitorSupport {
    private final Set<EventProcessingMonitor> delegates = new CopyOnWriteArraySet<EventProcessingMonitor>();

    @Override
    public void onEventProcessingCompleted(List<? extends EventMessage> eventMessages) {
        for (EventProcessingMonitor delegate : this.delegates) {
            delegate.onEventProcessingCompleted(eventMessages);
        }
    }

    @Override
    public void onEventProcessingFailed(List<? extends EventMessage> eventMessages, Throwable cause) {
        for (EventProcessingMonitor delegate : this.delegates) {
            delegate.onEventProcessingFailed(eventMessages, cause);
        }
    }

    @Override
    public void subscribeEventProcessingMonitor(EventProcessingMonitor monitor) {
        this.delegates.add(monitor);
    }

    @Override
    public void unsubscribeEventProcessingMonitor(EventProcessingMonitor monitor) {
        this.delegates.remove(monitor);
    }
}

