/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.axonframework.eventhandling.AbstractClusterSelector;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.EventListener;

public class ClassNamePrefixClusterSelector
extends AbstractClusterSelector {
    private final Map<String, Cluster> mappings;
    private final Cluster defaultCluster;

    public ClassNamePrefixClusterSelector(String prefix, Cluster cluster) {
        this(Collections.singletonMap(prefix, cluster));
    }

    public ClassNamePrefixClusterSelector(Map<String, Cluster> mappings) {
        this(mappings, null);
    }

    public ClassNamePrefixClusterSelector(Map<String, Cluster> mappings, Cluster defaultCluster) {
        this.defaultCluster = defaultCluster;
        this.mappings = new TreeMap<String, Cluster>(new ReverseStringComparator());
        this.mappings.putAll(mappings);
    }

    @Override
    public Cluster doSelectCluster(EventListener eventListener, Class<?> listenerType) {
        String listenerName = listenerType.getName();
        for (Map.Entry<String, Cluster> entry : this.mappings.entrySet()) {
            if (!listenerName.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultCluster;
    }

    private static class ReverseStringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -1653838988719816515L;

        private ReverseStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o2.compareTo(o1);
        }
    }
}

