/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.lang.annotation.Annotation;
import org.axonframework.eventhandling.AbstractClusterSelector;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.EventListener;

public class AnnotationClusterSelector
extends AbstractClusterSelector {
    private final Class<? extends Annotation> annotationType;
    private final Cluster cluster;
    private final boolean inspectSuperClasses;

    public AnnotationClusterSelector(Class<? extends Annotation> annotationType, Cluster cluster) {
        this(annotationType, cluster, false);
    }

    public AnnotationClusterSelector(Class<? extends Annotation> annotationType, Cluster cluster, boolean inspectSuperClasses) {
        this.annotationType = annotationType;
        this.cluster = cluster;
        this.inspectSuperClasses = inspectSuperClasses;
    }

    @Override
    protected Cluster doSelectCluster(EventListener eventListener, Class<?> listenerType) {
        return this.annotationPresent(listenerType) ? this.cluster : null;
    }

    private boolean annotationPresent(Class<?> listenerType) {
        return listenerType.isAnnotationPresent(this.annotationType) || this.inspectSuperClasses && listenerType.getSuperclass() != null && this.annotationPresent(listenerType.getSuperclass());
    }
}

