/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.domain;

import java.util.Map;
import org.axonframework.domain.IdentifierFactory;
import org.axonframework.domain.Message;
import org.axonframework.domain.MetaData;

public class GenericMessage<T>
implements Message<T> {
    private static final long serialVersionUID = 4672240170797058482L;
    private final String identifier;
    private final MetaData metaData;
    private final Class payloadType;
    private final T payload;

    public GenericMessage(T payload) {
        this(payload, MetaData.emptyInstance());
    }

    public GenericMessage(T payload, Map<String, ?> metaData) {
        this(IdentifierFactory.getInstance().generateIdentifier(), payload, MetaData.from(metaData));
    }

    public GenericMessage(String identifier, T payload, Map<String, ?> metaData) {
        this.identifier = identifier;
        this.metaData = MetaData.from(metaData);
        this.payload = payload;
        this.payloadType = payload.getClass();
    }

    private GenericMessage(GenericMessage<T> original, Map<String, ?> metaData) {
        this.identifier = original.getIdentifier();
        this.payload = original.getPayload();
        this.payloadType = this.payload.getClass();
        this.metaData = MetaData.from(metaData);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    @Override
    public Class getPayloadType() {
        return this.payloadType;
    }

    @Override
    public GenericMessage<T> withMetaData(Map<String, ?> newMetaData) {
        if (this.metaData.equals(newMetaData)) {
            return this;
        }
        return new GenericMessage<T>(this, newMetaData);
    }

    @Override
    public GenericMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
        if (additionalMetaData.isEmpty()) {
            return this;
        }
        return new GenericMessage<T>(this, (Map<String, ?>)this.metaData.mergedWith(additionalMetaData));
    }
}

