/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.domain;

import java.util.Map;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericMessage;
import org.axonframework.domain.IdentifierFactory;
import org.axonframework.domain.Message;
import org.axonframework.domain.MetaData;
import org.joda.time.DateTime;

public class GenericEventMessage<T>
extends GenericMessage<T>
implements EventMessage<T> {
    private static final long serialVersionUID = -8370948891267874107L;
    private final DateTime timestamp;

    public static <T> EventMessage<T> asEventMessage(Object event) {
        if (EventMessage.class.isInstance(event)) {
            return (EventMessage)event;
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return new GenericEventMessage(message.getPayload(), message.getMetaData());
        }
        return new GenericEventMessage<Object>(event);
    }

    public GenericEventMessage(T payload) {
        this(payload, MetaData.emptyInstance());
    }

    public GenericEventMessage(T payload, Map<String, ?> metaData) {
        super(IdentifierFactory.getInstance().generateIdentifier(), payload, metaData);
        this.timestamp = new DateTime();
    }

    public GenericEventMessage(String identifier, DateTime timestamp, T payload, Map<String, ?> metaData) {
        super(identifier, payload, metaData);
        this.timestamp = timestamp;
    }

    private GenericEventMessage(GenericEventMessage<T> original, Map<String, ?> metaData) {
        super(original.getIdentifier(), original.getPayload(), metaData);
        this.timestamp = original.getTimestamp();
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public GenericEventMessage<T> withMetaData(Map<String, ?> newMetaData) {
        if (this.getMetaData().equals(newMetaData)) {
            return this;
        }
        return new GenericEventMessage<T>(this, newMetaData);
    }

    @Override
    public GenericEventMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
        if (additionalMetaData.isEmpty()) {
            return this;
        }
        return new GenericEventMessage<T>(this, (Map<String, ?>)this.getMetaData().mergedWith(additionalMetaData));
    }

    public String toString() {
        return String.format("GenericEventMessage[%s]", this.getPayload().toString());
    }
}

