/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import java.util.List;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.LockingStrategy;
import org.axonframework.contextsupport.spring.SnapshotterTriggerBeanDefinitionParser;
import org.axonframework.contextsupport.spring.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.CachingEventSourcingRepository;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventstore.EventStore;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class RepositoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String CONFLICT_RESOLVER_ATTRIBUTE = "conflict-resolver";
    private static final String EVENT_STORE_ATTRIBUTE = "event-store";
    private static final String EVENT_BUS_ATTRIBUTE = "event-bus";
    private static final String LOCKING_STRATEGY_ATTRIBUTE = "locking-strategy";
    private static final String LOCK_MANAGER_ATTRIBUTE = "lock-manager";
    private static final String AGGREGATE_ROOT_TYPE_ATTRIBUTE = "aggregate-type";
    private static final String AGGREGATE_FACTORY_ATTRIBUTE = "aggregate-factory";
    private static final String CACHE_ATTRIBUTE = "cache-ref";
    private static final String EVENT_PROCESSORS_ELEMENT = "event-processors";
    private static final String SNAPSHOT_TRIGGER_ELEMENT = "snapshotter-trigger";
    private static final String EVENT_STREAM_DECORATORS_PROPERTY = "eventStreamDecorators";
    private static final String SNAPSHOTTER_TRIGGER_PROPERTY = "snapshotterTrigger";
    private final SnapshotterTriggerBeanDefinitionParser snapshotterTriggerParser = new SnapshotterTriggerBeanDefinitionParser();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        GenericBeanDefinition repositoryDefinition = new GenericBeanDefinition();
        if (element.hasAttribute(CACHE_ATTRIBUTE)) {
            repositoryDefinition.setBeanClass(CachingEventSourcingRepository.class);
        } else {
            repositoryDefinition.setBeanClass(EventSourcingRepository.class);
        }
        this.parseAggregateFactory(element, repositoryDefinition, parserContext.getRegistry());
        this.parseEventStore(element, repositoryDefinition);
        this.parseLockingStrategy(element, repositoryDefinition);
        this.parseReferenceAttribute(element, EVENT_BUS_ATTRIBUTE, "eventBus", repositoryDefinition.getPropertyValues(), EventBus.class);
        this.parseReferenceAttribute(element, CONFLICT_RESOLVER_ATTRIBUTE, "conflictResolver", repositoryDefinition.getPropertyValues(), null);
        this.parseReferenceAttribute(element, CACHE_ATTRIBUTE, "cache", repositoryDefinition.getPropertyValues(), null);
        this.parseProcessors(element, parserContext, repositoryDefinition);
        return repositoryDefinition;
    }

    private void parseEventStore(Element element, GenericBeanDefinition repositoryDefinition) {
        Object eventStore = element.hasAttribute(EVENT_STORE_ATTRIBUTE) ? new RuntimeBeanReference(element.getAttribute(EVENT_STORE_ATTRIBUTE)) : AutowiredBean.createAutowiredBean(EventStore.class);
        repositoryDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, eventStore);
    }

    private void parseProcessors(Element element, ParserContext parserContext, GenericBeanDefinition beanDefinition) {
        List processorsList;
        Element processorsElement = DomUtils.getChildElementByTagName((Element)element, (String)EVENT_PROCESSORS_ELEMENT);
        Element snapshotTriggerElement = DomUtils.getChildElementByTagName((Element)element, (String)SNAPSHOT_TRIGGER_ELEMENT);
        if (snapshotTriggerElement != null) {
            BeanDefinition triggerDefinition = this.snapshotterTriggerParser.parse(snapshotTriggerElement, parserContext);
            PropertyValue aggregateCache = beanDefinition.getPropertyValues().getPropertyValue("cache");
            if (aggregateCache != null) {
                triggerDefinition.getPropertyValues().add("aggregateCache", aggregateCache.getValue());
            }
            beanDefinition.getPropertyValues().add(SNAPSHOTTER_TRIGGER_PROPERTY, (Object)triggerDefinition);
        }
        if (processorsElement != null && !(processorsList = parserContext.getDelegate().parseListElement(processorsElement, (BeanDefinition)beanDefinition)).isEmpty()) {
            beanDefinition.getPropertyValues().add(EVENT_STREAM_DECORATORS_PROPERTY, (Object)processorsList);
        }
    }

    private void parseReferenceAttribute(Element element, String referenceName, String propertyName, MutablePropertyValues properties, Class<?> autowiredType) {
        if (element.hasAttribute(referenceName)) {
            properties.add(propertyName, (Object)new RuntimeBeanReference(element.getAttribute(referenceName)));
        } else if (autowiredType != null) {
            properties.add(propertyName, (Object)AutowiredBean.createAutowiredBean(autowiredType));
        }
    }

    private void parseLockingStrategy(Element element, GenericBeanDefinition builder) {
        if (element.hasAttribute(LOCK_MANAGER_ATTRIBUTE)) {
            String lockManager = element.getAttribute(LOCK_MANAGER_ATTRIBUTE);
            builder.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)new RuntimeBeanReference(lockManager));
        } else if (element.hasAttribute(LOCKING_STRATEGY_ATTRIBUTE)) {
            LockingStrategy strategy = LockingStrategy.valueOf(element.getAttribute(LOCKING_STRATEGY_ATTRIBUTE));
            GenericBeanDefinition lockManager = new GenericBeanDefinition();
            lockManager.setBeanClass(strategy.getLockManagerType());
            builder.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)lockManager);
        }
    }

    private void parseAggregateFactory(Element element, GenericBeanDefinition builder, BeanDefinitionRegistry registry) {
        RuntimeBeanReference aggregateFactory;
        String aggregateFactoryRef = element.getAttribute(AGGREGATE_FACTORY_ATTRIBUTE);
        String aggregateType = element.getAttribute(AGGREGATE_ROOT_TYPE_ATTRIBUTE);
        if (StringUtils.hasText((String)aggregateFactoryRef)) {
            aggregateFactory = new RuntimeBeanReference(aggregateFactoryRef);
        } else if (StringUtils.hasText((String)aggregateType)) {
            aggregateFactory = BeanDefinitionBuilder.genericBeanDefinition(GenericAggregateFactory.class).addConstructorArgValue((Object)aggregateType).addConstructorArgValue((Object)SpringContextParameterResolverFactoryBuilder.getBeanReference(registry)).getBeanDefinition();
        } else {
            throw new BeanDefinitionValidationException("You must provide either an aggregate-type or an aggregate-factory in each event-sourcing-repository element.");
        }
        builder.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)aggregateFactory);
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

