/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import org.axonframework.common.jpa.ContainerManagedEntityManagerProvider;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.LockingStrategy;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.HybridJpaRepository;
import org.axonframework.repository.GenericJpaRepository;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.w3c.dom.Element;

public class JpaRepositoryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ENTITY_MANAGER_PROVIDER = "entity-manager-provider";
    private static final String EVENT_BUS = "event-bus";
    private static final String EVENT_STORE = "event-store";
    private static final String LOCK_MANAGER = "lock-manager";
    private static final String LOCKING_STRATEGY = "locking-strategy";
    private static final String AGGREGATE_TYPE = "aggregate-type";

    protected Class<?> getBeanClass(Element element) {
        if (element.hasAttribute(EVENT_STORE)) {
            return HybridJpaRepository.class;
        }
        return GenericJpaRepository.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(ENTITY_MANAGER_PROVIDER)) {
            builder.addConstructorArgReference(element.getAttribute(ENTITY_MANAGER_PROVIDER));
        } else {
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(ContainerManagedEntityManagerProvider.class).getBeanDefinition());
        }
        builder.addConstructorArgValue((Object)element.getAttribute(AGGREGATE_TYPE));
        this.parseLockManager(element, builder);
        this.parseEventStore(element, builder);
        this.parseEventBus(element, builder);
    }

    private void parseLockManager(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(LOCK_MANAGER)) {
            builder.addConstructorArgReference(element.getAttribute(LOCK_MANAGER));
        } else if (element.hasAttribute(LOCKING_STRATEGY)) {
            LockingStrategy strategy = LockingStrategy.valueOf(element.getAttribute(LOCKING_STRATEGY));
            GenericBeanDefinition lockManager = new GenericBeanDefinition();
            lockManager.setBeanClass(strategy.getLockManagerType());
            builder.addConstructorArgValue((Object)lockManager);
        }
    }

    private void parseEventBus(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(EVENT_BUS)) {
            builder.addPropertyReference("eventBus", element.getAttribute(EVENT_BUS));
        } else {
            builder.addPropertyValue("eventBus", (Object)AutowiredBean.createAutowiredBean(EventBus.class));
        }
    }

    private void parseEventStore(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(EVENT_STORE)) {
            builder.addPropertyReference("eventStore", element.getAttribute(EVENT_STORE));
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

