/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import javax.sql.DataSource;
import org.axonframework.cache.NoCache;
import org.axonframework.common.jdbc.SpringDataSourceConnectionProvider;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.saga.repository.CachingSagaRepository;
import org.axonframework.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.saga.repository.jdbc.JdbcSagaRepository;
import org.axonframework.saga.spring.SpringResourceInjector;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JdbcSagaRepositoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String RESOURCE_INJECTOR_ATTRIBUTE = "resource-injector";
    private static final String SAGA_SERIALIZER_ATTRIBUTE = "saga-serializer";
    private static final String SAGA_SERIALIZER_PROPERTY = "serializer";
    private static final String CONNECTION_PROVIDER = "connection-provider";
    private static final String DATA_SOURCE = "data-source";
    private static final String ATTRIBUTE_SAGA_CACHE = "saga-cache";
    private static final String SQL_SCHEMA = "sql-schema";
    private static final String ATTRIBUTE_ASSOCIATIONS_CACHE = "associations-cache";
    private static final String ELEMENT_CACHE_CONFIG = "cache-config";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcSagaRepository.class);
        this.parseResourceInjectorAttribute(element, builder);
        this.parseSagaSerializerAttribute(element, builder);
        this.parseConnectionProvider(element, builder);
        this.parseSqlSchema(element, builder);
        return this.parseCacheConfig(element, builder.getBeanDefinition());
    }

    private AbstractBeanDefinition parseCacheConfig(Element element, AbstractBeanDefinition beanDefinition) {
        Element cacheConfigElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_CACHE_CONFIG);
        if (cacheConfigElement != null) {
            GenericBeanDefinition cachedRepoDef = new GenericBeanDefinition();
            cachedRepoDef.setBeanClass(CachingSagaRepository.class);
            NoCache sagaCacheReference = cacheConfigElement.hasAttribute(ATTRIBUTE_SAGA_CACHE) ? new RuntimeBeanReference(cacheConfigElement.getAttribute(ATTRIBUTE_SAGA_CACHE)) : NoCache.INSTANCE;
            NoCache associationsCacheReference = cacheConfigElement.hasAttribute(ATTRIBUTE_ASSOCIATIONS_CACHE) ? new RuntimeBeanReference(cacheConfigElement.getAttribute(ATTRIBUTE_ASSOCIATIONS_CACHE)) : NoCache.INSTANCE;
            cachedRepoDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanDefinition);
            cachedRepoDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)associationsCacheReference);
            cachedRepoDef.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)sagaCacheReference);
            return cachedRepoDef;
        }
        return beanDefinition;
    }

    private void parseSqlSchema(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(SQL_SCHEMA)) {
            builder.addConstructorArgReference(element.getAttribute(SQL_SCHEMA));
        } else {
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(GenericSagaSqlSchema.class).getBeanDefinition());
        }
    }

    private void parseConnectionProvider(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(CONNECTION_PROVIDER)) {
            builder.addConstructorArgReference(element.getAttribute(CONNECTION_PROVIDER));
        } else {
            BeanDefinitionBuilder dataSourceProviderBean = BeanDefinitionBuilder.genericBeanDefinition(SpringDataSourceConnectionProvider.class);
            if (element.hasAttribute(DATA_SOURCE)) {
                dataSourceProviderBean.addConstructorArgReference(element.getAttribute(DATA_SOURCE));
            } else {
                dataSourceProviderBean.addConstructorArgValue((Object)AutowiredBean.createAutowiredBean(DataSource.class));
            }
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(UnitOfWorkAwareConnectionProviderWrapper.class).addConstructorArgValue((Object)dataSourceProviderBean.getBeanDefinition()).getBeanDefinition());
        }
    }

    private void parseSagaSerializerAttribute(Element element, BeanDefinitionBuilder beanDefinition) {
        if (element.hasAttribute(SAGA_SERIALIZER_ATTRIBUTE)) {
            beanDefinition.addPropertyReference(SAGA_SERIALIZER_PROPERTY, element.getAttribute(SAGA_SERIALIZER_ATTRIBUTE));
        }
    }

    private void parseResourceInjectorAttribute(Element element, BeanDefinitionBuilder beanDefinition) {
        if (element.hasAttribute(RESOURCE_INJECTOR_ATTRIBUTE)) {
            beanDefinition.addPropertyReference("resourceInjector", element.getAttribute(RESOURCE_INJECTOR_ATTRIBUTE));
        } else {
            GenericBeanDefinition defaultResourceInjector = new GenericBeanDefinition();
            defaultResourceInjector.setBeanClass(SpringResourceInjector.class);
            beanDefinition.addPropertyValue("resourceInjector", (Object)defaultResourceInjector);
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

