/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.commandhandling.disruptor.DisruptorCommandBus;
import org.axonframework.commandhandling.disruptor.DisruptorConfiguration;
import org.axonframework.common.Assert;
import org.axonframework.contextsupport.spring.DisruptorRepositoryBeanDefinitionParser;
import org.axonframework.contextsupport.spring.TransactionManagerFactoryBean;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DisruptorCommandBusBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String ATTRIBUTE_EVENT_STORE = "event-store";
    private static final String ATTRIBUTE_EVENT_BUS = "event-bus";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String ATTRIBUTE_ID = "id";
    private static final String PROPERTY_WAIT_STRATEGY = "waitStrategy";
    private static final String ATTRIBUTE_WAIT_STRATEGY = "wait-strategy";
    private static final String ATTRIBUTE_CLAIM_STRATEGY = "claim-strategy";
    private static final String PROPERTY_PRODUCER_TYPE = "producerType";
    private static final String ATTRIBUTE_PRODUCER_TYPE = "producer-type";
    private static final String ELEMENT_REPOSITORIES = "repositories";
    private static final String ATTRIBUTE_TRANSACTION_MANAGER = "transaction-manager";
    private static final String PROPERTY_TRANSACTION_MANAGER = "transactionManager";
    private static final Map<String, String> VALUE_PROPERTY_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> REF_PROPERTY_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> LIST_PROPERTY_MAPPING = new HashMap<String, String>();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinition configurationDefinition = this.createConfiguration(element, parserContext);
        AbstractBeanDefinition definition = BeanDefinitionBuilder.genericBeanDefinition(DisruptorCommandBus.class).addConstructorArgReference(element.getAttribute(ATTRIBUTE_EVENT_STORE)).addConstructorArgReference(element.getAttribute(ATTRIBUTE_EVENT_BUS)).addConstructorArgValue((Object)configurationDefinition).getBeanDefinition();
        Element repoElement = DomUtils.getChildElementByTagName((Element)element, (String)ELEMENT_REPOSITORIES);
        if (repoElement != null) {
            List repositories = DomUtils.getChildElementsByTagName((Element)repoElement, (String)ELEMENT_REPOSITORY);
            String id = super.resolveId(element, definition, parserContext);
            for (Element repository : repositories) {
                this.parseRepository(repository, id, parserContext, configurationDefinition.getPropertyValues().getPropertyValue("cache"));
            }
        }
        definition.setDestroyMethodName("stop");
        return definition;
    }

    private BeanDefinition createConfiguration(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DisruptorConfiguration.class);
        for (Map.Entry<String, String> entry : REF_PROPERTY_MAPPING.entrySet()) {
            if (!element.hasAttribute(entry.getKey())) continue;
            builder.addPropertyReference(entry.getValue(), element.getAttribute(entry.getKey()));
        }
        for (Map.Entry<String, String> entry : VALUE_PROPERTY_MAPPING.entrySet()) {
            if (!element.hasAttribute(entry.getKey())) continue;
            builder.addPropertyValue(entry.getValue(), (Object)element.getAttribute(entry.getKey()));
        }
        this.parseClaimStrategy(element, builder);
        this.parseProducerType(element, builder);
        this.parseWaitStrategy(element, builder);
        this.parseTransactionManager(element, builder);
        for (Map.Entry<String, String> entry : LIST_PROPERTY_MAPPING.entrySet()) {
            Element interceptorsElement = DomUtils.getChildElementByTagName((Element)element, (String)entry.getKey());
            if (interceptorsElement == null) continue;
            builder.addPropertyValue(entry.getValue(), (Object)parserContext.getDelegate().parseListElement(interceptorsElement, (BeanDefinition)builder.getBeanDefinition()));
        }
        return builder.getBeanDefinition();
    }

    private void parseTransactionManager(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(ATTRIBUTE_TRANSACTION_MANAGER)) {
            String txManagerId = element.getAttribute(ATTRIBUTE_TRANSACTION_MANAGER);
            builder.addPropertyValue(PROPERTY_TRANSACTION_MANAGER, (Object)BeanDefinitionBuilder.genericBeanDefinition(TransactionManagerFactoryBean.class).addPropertyReference(PROPERTY_TRANSACTION_MANAGER, txManagerId).getBeanDefinition());
        }
    }

    @Deprecated
    private void parseClaimStrategy(Element element, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder producerType = BeanDefinitionBuilder.genericBeanDefinition(ProducerTypeFactoryBean.class);
        if (element.hasAttribute(ATTRIBUTE_CLAIM_STRATEGY)) {
            producerType.addPropertyValue("type", (Object)element.getAttribute(ATTRIBUTE_CLAIM_STRATEGY));
        }
        builder.addPropertyValue(PROPERTY_PRODUCER_TYPE, (Object)producerType.getBeanDefinition());
    }

    private void parseProducerType(Element element, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder producerType = BeanDefinitionBuilder.genericBeanDefinition(ProducerTypeFactoryBean.class);
        if (element.hasAttribute(ATTRIBUTE_PRODUCER_TYPE)) {
            producerType.addPropertyValue("type", (Object)element.getAttribute(ATTRIBUTE_PRODUCER_TYPE));
        }
        builder.addPropertyValue(PROPERTY_PRODUCER_TYPE, (Object)producerType.getBeanDefinition());
    }

    private void parseWaitStrategy(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(ATTRIBUTE_WAIT_STRATEGY)) {
            String waitStrategy = element.getAttribute(ATTRIBUTE_WAIT_STRATEGY);
            builder.addPropertyValue(PROPERTY_WAIT_STRATEGY, (Object)BeanDefinitionBuilder.genericBeanDefinition(WaitStrategyFactoryBean.class).addConstructorArgValue((Object)waitStrategy).getBeanDefinition());
        }
    }

    private void parseRepository(Element repository, String commandBusId, ParserContext parserContext, PropertyValue aggregateCache) {
        String id = repository.getAttribute(ATTRIBUTE_ID);
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)new DisruptorRepositoryBeanDefinitionParser().createRepositoryDefinition(repository, commandBusId, parserContext, aggregateCache));
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    static {
        REF_PROPERTY_MAPPING.put("cache", "cache");
        REF_PROPERTY_MAPPING.put("executor", "executor");
        REF_PROPERTY_MAPPING.put("rollback-configuration", "rollbackConfiguration");
        REF_PROPERTY_MAPPING.put("serializer", "serializer");
        REF_PROPERTY_MAPPING.put("command-target-resolver", "commandTargetResolver");
        VALUE_PROPERTY_MAPPING.put("cooling-down-period", "coolingDownPeriod");
        VALUE_PROPERTY_MAPPING.put("invoker-threads", "invokerThreadCount");
        VALUE_PROPERTY_MAPPING.put("serializer-threads", "serializerThreadCount");
        VALUE_PROPERTY_MAPPING.put("publisher-threads", "publisherThreadCount");
        VALUE_PROPERTY_MAPPING.put("reschedule-commands-on-corrupt-state", "rescheduleCommandsOnCorruptState");
        VALUE_PROPERTY_MAPPING.put("serialized-representation", "serializedRepresentation");
        VALUE_PROPERTY_MAPPING.put("buffer-size", "bufferSize");
        LIST_PROPERTY_MAPPING.put("invoker-interceptors", "invokerInterceptors");
        LIST_PROPERTY_MAPPING.put("publisher-interceptors", "publisherInterceptors");
        LIST_PROPERTY_MAPPING.put("dispatcher-interceptors", "dispatchInterceptors");
    }

    private static final class WaitStrategyFactoryBean
    implements FactoryBean<WaitStrategy> {
        private final WaitStrategy waitStrategy;

        private WaitStrategyFactoryBean(String strategyName) {
            if ("busy-spin".equals(strategyName)) {
                this.waitStrategy = new BusySpinWaitStrategy();
            } else if ("yield".equals(strategyName)) {
                this.waitStrategy = new YieldingWaitStrategy();
            } else if ("sleep".equals(strategyName)) {
                this.waitStrategy = new SleepingWaitStrategy();
            } else if ("block".equals(strategyName)) {
                this.waitStrategy = new BlockingWaitStrategy();
            } else {
                throw new IllegalArgumentException("WaitStrategy is not one of the allowed values: busy-spin, yield, sleep or block.");
            }
        }

        public WaitStrategy getObject() throws Exception {
            return this.waitStrategy;
        }

        public Class<?> getObjectType() {
            return WaitStrategy.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    private static final class ProducerTypeFactoryBean
    implements FactoryBean<ProducerType>,
    InitializingBean {
        private ProducerType producerType;
        private String type;

        private ProducerTypeFactoryBean() {
        }

        public ProducerType getObject() throws Exception {
            return this.producerType;
        }

        public Class<?> getObjectType() {
            return ProducerType.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void afterPropertiesSet() throws Exception {
            this.producerType = "single-threaded".equals(this.type) ? ProducerType.SINGLE : ProducerType.MULTI;
        }

        public void setType(String type) {
            Assert.isTrue("single-threaded".equals(type) || "multi-threaded".equals(type), "The given value for producer type (" + type + ") is not valid. It must either be 'single-threaded' or 'multi-threaded'.");
            this.type = type;
        }
    }
}

