/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.TransactionManagerFactoryBean;
import org.axonframework.eventhandling.AnnotationClusterSelector;
import org.axonframework.eventhandling.ClassNamePatternClusterSelector;
import org.axonframework.eventhandling.ClassNamePrefixClusterSelector;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.ClusterSelector;
import org.axonframework.eventhandling.DefaultClusterSelector;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.SimpleCluster;
import org.axonframework.eventhandling.SpringAnnotationOrderResolver;
import org.axonframework.eventhandling.replay.BackloggingIncomingMessageHandler;
import org.axonframework.eventhandling.replay.DiscardingIncomingMessageHandler;
import org.axonframework.eventhandling.replay.IncomingMessageHandler;
import org.axonframework.eventhandling.replay.ReplayingCluster;
import org.axonframework.eventstore.management.EventStoreManagement;
import org.axonframework.unitofwork.NoTransactionManager;
import org.axonframework.unitofwork.TransactionManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ClusterBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String META_DATA_ELEMENT = "meta-data";
    private static final String REPLAY_ELEMENT = "replay-config";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String EVENT_STORE_ATTRIBUTE = "event-store";
    private static final String COMMIT_THRESHOLD_ATTRIBUTE = "commit-threshold";
    private static final String INCOMING_MESSAGE_HANDLER_REF = "incoming-message-handler-ref";
    private static final String INCOMING_MESSAGES_ATTRIBUTE = "incoming-messages";
    private static final String SELECTORS_ELEMENT = "selectors";
    private static final String SELECTOR_CLASS_NAME_MATCHES_ELEMENT = "class-name-matches";
    private static final String SELECTOR_PACKAGE_ELEMENT = "package";
    private static final String SELECTOR_ANNOTATION_ELEMENT = "annotation";
    private static final String DEFAULT_SELECTOR_SUFFIX = "$defaultSelector";
    private static final String SELECTOR_SUFFIX = "$selector";
    private static final String PREFIX_ATTRIBUTE = "prefix";
    private static final String PATTERN_ATTRIBUTE = "pattern";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String ORDER_ATTRIBUTE = "order";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CHECK_SUPERCLASS_ATTRIBUTE = "check-superclass";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        GenericBeanDefinition innerCluster;
        Element innerBeanElement = DomUtils.getChildElementByTagName((Element)element, (String)"bean");
        if (innerBeanElement != null) {
            innerCluster = parserContext.getDelegate().parseBeanDefinitionElement(innerBeanElement, null, null);
        } else {
            innerCluster = new GenericBeanDefinition();
            String clusterType = element.getAttribute(TYPE_ATTRIBUTE);
            if (StringUtils.hasText((String)clusterType)) {
                innerCluster.setBeanClassName(clusterType);
            } else {
                innerCluster.setBeanClass(SimpleCluster.class);
            }
            innerCluster.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)this.resolveId(element, (AbstractBeanDefinition)innerCluster, parserContext));
            Element orderedElement = DomUtils.getChildElementByTagName((Element)element, (String)"ordered");
            if (orderedElement != null) {
                innerCluster.getConstructorArgumentValues().addGenericArgumentValue(this.parseOrderElement(orderedElement));
            }
        }
        Map metaData = this.parseMetaData(element, parserContext, null);
        GenericBeanDefinition clusterBean = new GenericBeanDefinition();
        clusterBean.setBeanClass(MetaDataOverridingCluster.class);
        clusterBean.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)innerCluster);
        clusterBean.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)metaData);
        String clusterId = this.resolveId(element, (AbstractBeanDefinition)clusterBean, parserContext);
        boolean hasSelectors = this.parseClusterSelector(element, parserContext, clusterId);
        boolean hasDefault = this.parseDefaultSelector(element, parserContext, clusterId);
        if (!hasSelectors && !hasDefault) {
            throw new AxonConfigurationException("Cluster with id '" + clusterId + "' is not a default cluster, nor defines any selectors");
        }
        if (DomUtils.getChildElementByTagName((Element)element, (String)REPLAY_ELEMENT) != null) {
            return this.wrapInReplayingCluster(DomUtils.getChildElementByTagName((Element)element, (String)REPLAY_ELEMENT), (AbstractBeanDefinition)clusterBean);
        }
        return clusterBean;
    }

    private Object parseOrderElement(Element orderedElement) {
        if (orderedElement.hasAttribute("order-resolver-ref")) {
            return new RuntimeBeanReference(orderedElement.getAttribute("order-resolver-ref"));
        }
        return BeanDefinitionBuilder.genericBeanDefinition(SpringAnnotationOrderResolver.class).getBeanDefinition();
    }

    private AbstractBeanDefinition wrapInReplayingCluster(Element replayElement, AbstractBeanDefinition targetClusterDefinition) {
        GenericBeanDefinition replayingCluster = new GenericBeanDefinition();
        replayingCluster.setBeanClass(ReplayingCluster.class);
        ConstructorArgumentValues constructor = replayingCluster.getConstructorArgumentValues();
        constructor.addIndexedArgumentValue(0, (Object)targetClusterDefinition);
        if (replayElement.hasAttribute(EVENT_STORE_ATTRIBUTE)) {
            constructor.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(replayElement.getAttribute(EVENT_STORE_ATTRIBUTE)));
        } else {
            constructor.addIndexedArgumentValue(1, (Object)AutowiredBean.createAutowiredBean(EventStoreManagement.class));
        }
        if (replayElement.hasAttribute(TRANSACTION_MANAGER_ATTRIBUTE)) {
            constructor.addIndexedArgumentValue(2, (Object)BeanDefinitionBuilder.genericBeanDefinition(TransactionManagerFactoryBean.class).addPropertyReference("transactionManager", replayElement.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE)).getBeanDefinition());
        } else {
            constructor.addIndexedArgumentValue(2, (Object)BeanDefinitionBuilder.genericBeanDefinition(TransactionManagerFactoryBean.class).addPropertyValue("transactionManager", (Object)AutowiredBean.createAutowiredBeanWithFallback(new NoTransactionManager(), TransactionManager.class, PlatformTransactionManager.class)).getBeanDefinition());
        }
        constructor.addIndexedArgumentValue(3, (Object)replayElement.getAttribute(COMMIT_THRESHOLD_ATTRIBUTE));
        Object incomingMessageHandlerDefinition = replayElement.hasAttribute(INCOMING_MESSAGE_HANDLER_REF) ? new RuntimeBeanReference(replayElement.getAttribute(INCOMING_MESSAGE_HANDLER_REF)) : BeanDefinitionBuilder.genericBeanDefinition(IncomingMessageHandlerFactoryBean.class).addPropertyValue("policy", (Object)replayElement.getAttribute(INCOMING_MESSAGES_ATTRIBUTE)).getBeanDefinition();
        constructor.addIndexedArgumentValue(4, incomingMessageHandlerDefinition);
        return replayingCluster;
    }

    private boolean parseClusterSelector(Element element, ParserContext parserContext, String clusterId) {
        GenericBeanDefinition selector = new GenericBeanDefinition();
        selector.setBeanClass(OrderedClusterSelector.class);
        selector.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)element.getAttribute(ORDER_ATTRIBUTE));
        Element selectorsElement = DomUtils.getChildElementByTagName((Element)element, (String)SELECTORS_ELEMENT);
        ManagedList selectors = new ManagedList();
        if (selectorsElement != null) {
            selectors.addAll(this.parseSelectors(selectorsElement, clusterId));
            parserContext.getRegistry().registerBeanDefinition(clusterId + SELECTOR_SUFFIX, (BeanDefinition)selector);
            selector.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)selectors);
        }
        return !selectors.isEmpty();
    }

    private boolean parseDefaultSelector(Element element, ParserContext parserContext, String clusterId) {
        boolean isDefault = Boolean.parseBoolean(element.getAttribute(DEFAULT_ATTRIBUTE));
        if (isDefault) {
            GenericBeanDefinition defaultSelector = new GenericBeanDefinition();
            defaultSelector.setBeanClass(OrderedClusterSelector.class);
            defaultSelector.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)Integer.MAX_VALUE);
            ManagedList definitions = new ManagedList();
            definitions.add((Object)BeanDefinitionBuilder.genericBeanDefinition(DefaultClusterSelector.class).addConstructorArgReference(clusterId).getBeanDefinition());
            defaultSelector.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)definitions);
            parserContext.getRegistry().registerBeanDefinition(clusterId + DEFAULT_SELECTOR_SUFFIX, (BeanDefinition)defaultSelector);
        }
        return isDefault;
    }

    private Map parseMetaData(Element element, ParserContext parserContext, AbstractBeanDefinition beanDefinition) {
        Element metaDataElement = DomUtils.getChildElementByTagName((Element)element, (String)META_DATA_ELEMENT);
        if (metaDataElement == null) {
            return new ManagedMap();
        }
        return parserContext.getDelegate().parseMapElement(metaDataElement, (BeanDefinition)beanDefinition);
    }

    private List<BeanDefinition> parseSelectors(Element selectorsElement, String clusterId) {
        List selectors = DomUtils.getChildElements((Element)selectorsElement);
        ManagedList selectorsList = new ManagedList(selectors.size());
        for (Element child : selectors) {
            BeanDefinition definition = this.parseSelector(child, clusterId);
            if (definition == null) continue;
            selectorsList.add((Object)definition);
        }
        return selectorsList;
    }

    private BeanDefinition parseSelector(Element item, String clusterId) {
        String nodeName = item.getLocalName();
        if (SELECTOR_CLASS_NAME_MATCHES_ELEMENT.equals(nodeName)) {
            return BeanDefinitionBuilder.genericBeanDefinition(ClassNamePatternClusterSelector.class).addConstructorArgValue((Object)item.getAttribute(PATTERN_ATTRIBUTE)).addConstructorArgReference(clusterId).getBeanDefinition();
        }
        if (SELECTOR_PACKAGE_ELEMENT.equals(nodeName)) {
            return BeanDefinitionBuilder.genericBeanDefinition(ClassNamePrefixClusterSelector.class).addConstructorArgValue((Object)item.getAttribute(PREFIX_ATTRIBUTE)).addConstructorArgReference(clusterId).getBeanDefinition();
        }
        if (SELECTOR_ANNOTATION_ELEMENT.equals(nodeName)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AnnotationClusterSelector.class).addConstructorArgValue((Object)item.getAttribute(TYPE_ATTRIBUTE)).addConstructorArgReference(clusterId);
            if (item.hasAttribute(CHECK_SUPERCLASS_ATTRIBUTE)) {
                builder.addConstructorArgValue((Object)item.getAttribute(CHECK_SUPERCLASS_ATTRIBUTE));
            }
            return builder.getBeanDefinition();
        }
        throw new AxonConfigurationException("No Cluster Selector known for element '" + item.getLocalName() + "'.");
    }

    private static class IncomingMessageHandlerFactoryBean
    implements FactoryBean<IncomingMessageHandler>,
    InitializingBean {
        private IncomingMessageHandler messageHandler;
        private String policy = "backlog";

        private IncomingMessageHandlerFactoryBean() {
        }

        public IncomingMessageHandler getObject() throws Exception {
            return this.messageHandler;
        }

        public Class<?> getObjectType() {
            return IncomingMessageHandler.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void afterPropertiesSet() throws Exception {
            this.messageHandler = "discard".equals(this.policy) ? new DiscardingIncomingMessageHandler() : new BackloggingIncomingMessageHandler();
        }

        public void setPolicy(String policy) {
            this.policy = policy;
        }
    }

    private static final class OrderedClusterSelector
    implements Ordered,
    ClusterSelector {
        private final int order;
        private final List<ClusterSelector> selectors;

        private OrderedClusterSelector(int order, List<ClusterSelector> selectors) {
            this.order = order;
            this.selectors = new ArrayList<ClusterSelector>(selectors);
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public Cluster selectCluster(EventListener eventListener) {
            Cluster cluster = null;
            Iterator<ClusterSelector> selectorIterator = this.selectors.iterator();
            while (cluster == null && selectorIterator.hasNext()) {
                cluster = selectorIterator.next().selectCluster(eventListener);
            }
            return cluster;
        }
    }

    private static final class MetaDataOverridingCluster
    implements FactoryBean<Cluster> {
        private final Cluster delegate;

        private MetaDataOverridingCluster(Cluster delegate, Map<String, Object> metaData) {
            this.delegate = delegate;
            for (Map.Entry<String, Object> entry : metaData.entrySet()) {
                delegate.getMetaData().setProperty(entry.getKey(), entry.getValue());
            }
        }

        public Cluster getObject() throws Exception {
            return this.delegate;
        }

        public Class<?> getObjectType() {
            return Cluster.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

