/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AutowiredDependencyFactoryBean
implements FactoryBean,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private final Class[] beanTypes;
    private final Object defaultBean;
    private Class<?> actualBeanType;
    private Object actualBean;

    public AutowiredDependencyFactoryBean(Class<?> ... beanTypes) {
        this((Object)null, beanTypes);
    }

    public AutowiredDependencyFactoryBean(Object defaultBean, Class<?> ... beanTypes) {
        this.beanTypes = beanTypes;
        this.defaultBean = defaultBean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object getObject() throws Exception {
        return this.actualBean;
    }

    public Class<?> getObjectType() {
        return this.actualBeanType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        for (int i = 0; i < this.beanTypes.length && this.actualBean == null; ++i) {
            this.actualBean = this.findAutowireCandidateOfType(this.beanTypes[i]);
        }
        if (this.actualBean == null) {
            this.actualBean = this.defaultBean;
        }
        if (this.actualBean == null) {
            throw new IllegalStateException("No autowire candidates have been found. Make sure at least one bean of one of the following types is available: " + Arrays.toString(this.beanTypes));
        }
        this.actualBeanType = this.actualBean.getClass();
    }

    private Object findAutowireCandidateOfType(Class<?> beanType) {
        String[] candidates = this.applicationContext.getBeanNamesForType(beanType);
        String primary = null;
        AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            String[] arr$ = candidates;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ConfigurableListableBeanFactory clBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
                String bean = arr$[i$];
                if (!clBeanFactory.containsBeanDefinition(bean) || !clBeanFactory.getBeanDefinition(bean).isPrimary()) continue;
                if (primary != null) {
                    throw new IllegalStateException(String.format("More than one bean of type [%s] marked as primary. Found '%s' and '%s'.", beanType.getName(), primary, bean));
                }
                primary = bean;
            }
        }
        if (primary == null && candidates.length == 1) {
            primary = candidates[0];
        } else if (primary == null && candidates.length > 1) {
            throw new IllegalStateException("More than one bean of type [" + beanType.getName() + "] is eligible for autowiring, " + "and none of them is marked as primary.");
        }
        return primary == null ? null : this.applicationContext.getBean(primary);
    }
}

