/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import org.axonframework.commandhandling.annotation.AnnotationCommandHandlerBeanPostProcessor;
import org.axonframework.contextsupport.spring.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.eventhandling.annotation.AnnotationEventListenerBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationConfigurationBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String EVENT_BUS_ATTRIBUTE = "event-bus";
    private static final String COMMAND_BUS_ATTRIBUTE = "command-bus";
    private static final String EVENT_LISTENER_BEAN_NAME = "__axon-annotation-event-listener-bean-post-processor";
    private static final String COMMAND_HANDLER_BEAN_NAME = "__axon-annotation-command-handler-bean-post-processor";
    private static final String PHASE_ATTRIBUTE = "phase";
    private static final String UNSUBSCRIBE_ON_SHUTDOWN_ATTRIBUTE = "unsubscribe-handlers-on-shutdown";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String phase = element.hasAttribute(PHASE_ATTRIBUTE) ? element.getAttribute(PHASE_ATTRIBUTE) : null;
        String unsubscribe = element.hasAttribute(UNSUBSCRIBE_ON_SHUTDOWN_ATTRIBUTE) ? element.getAttribute(UNSUBSCRIBE_ON_SHUTDOWN_ATTRIBUTE) : null;
        String eventBus = element.hasAttribute(EVENT_BUS_ATTRIBUTE) ? element.getAttribute(EVENT_BUS_ATTRIBUTE) : null;
        String commandBus = element.hasAttribute(COMMAND_BUS_ATTRIBUTE) ? element.getAttribute(COMMAND_BUS_ATTRIBUTE) : null;
        this.registerAnnotationCommandHandlerBeanPostProcessor(commandBus, phase, unsubscribe, parserContext.getRegistry());
        this.registerAnnotationEventListenerBeanPostProcessor(eventBus, phase, unsubscribe, parserContext.getRegistry());
        return null;
    }

    public void registerAnnotationEventListenerBeanPostProcessor(String eventBus, String phase, String unsubscribeOnShutdown, BeanDefinitionRegistry registry) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(AnnotationEventListenerBeanPostProcessor.class);
        beanDefinition.getPropertyValues().add("parameterResolverFactory", (Object)SpringContextParameterResolverFactoryBuilder.getBeanReference(registry));
        if (StringUtils.hasText((String)phase)) {
            beanDefinition.getPropertyValues().add(PHASE_ATTRIBUTE, (Object)phase);
        }
        if (StringUtils.hasText((String)unsubscribeOnShutdown)) {
            beanDefinition.getPropertyValues().add("unsubscribeOnShutdown", (Object)unsubscribeOnShutdown);
        }
        if (StringUtils.hasText((String)eventBus)) {
            RuntimeBeanReference beanReference = new RuntimeBeanReference(eventBus);
            beanDefinition.getPropertyValues().addPropertyValue("eventBus", (Object)beanReference);
        }
        registry.registerBeanDefinition(EVENT_LISTENER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    public void registerAnnotationCommandHandlerBeanPostProcessor(String commandBus, String phase, String unsubscribeOnShutdown, BeanDefinitionRegistry registry) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(AnnotationCommandHandlerBeanPostProcessor.class);
        beanDefinition.getPropertyValues().add("parameterResolverFactory", (Object)SpringContextParameterResolverFactoryBuilder.getBeanReference(registry));
        if (StringUtils.hasText((String)phase)) {
            beanDefinition.getPropertyValues().add(PHASE_ATTRIBUTE, (Object)phase);
        }
        if (StringUtils.hasText((String)unsubscribeOnShutdown)) {
            beanDefinition.getPropertyValues().add("unsubscribeOnShutdown", (Object)unsubscribeOnShutdown);
        }
        if (StringUtils.hasText((String)commandBus)) {
            RuntimeBeanReference beanReference = new RuntimeBeanReference(commandBus);
            beanDefinition.getPropertyValues().addPropertyValue("commandBus", (Object)beanReference);
        }
        registry.registerBeanDefinition(COMMAND_HANDLER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }
}

