/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.lock;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.common.lock.IllegalLockUsageException;
import org.axonframework.common.lock.LockAcquisitionFailedException;

public class IdentifierBasedLock {
    private static final Set<IdentifierBasedLock> INSTANCES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private final ConcurrentHashMap<String, DisposableLock> locks = new ConcurrentHashMap();

    public IdentifierBasedLock() {
        INSTANCES.add(this);
    }

    private static Set<Thread> threadsWaitingForMyLocks(Thread owner) {
        return IdentifierBasedLock.threadsWaitingForMyLocks(owner, INSTANCES);
    }

    private static Set<Thread> threadsWaitingForMyLocks(Thread owner, Set<IdentifierBasedLock> locksInUse) {
        HashSet<Thread> waitingThreads = new HashSet<Thread>();
        for (IdentifierBasedLock lock : locksInUse) {
            for (DisposableLock disposableLock : lock.locks.values()) {
                if (!disposableLock.isHeldBy(owner)) continue;
                Collection<Thread> c = disposableLock.queuedThreads();
                for (Thread thread : c) {
                    if (!waitingThreads.add(thread)) continue;
                    waitingThreads.addAll(IdentifierBasedLock.threadsWaitingForMyLocks(thread, locksInUse));
                }
            }
        }
        return waitingThreads;
    }

    public boolean hasLock(String identifier) {
        return this.isLockAvailableFor(identifier) && this.lockFor(identifier).isHeldByCurrentThread();
    }

    public void obtainLock(String identifier) {
        boolean lockObtained = false;
        while (!lockObtained) {
            DisposableLock lock = this.lockFor(identifier);
            lockObtained = lock.lock();
            if (lockObtained) continue;
            this.locks.remove(identifier, lock);
        }
    }

    public void releaseLock(String identifier) {
        if (!this.locks.containsKey(identifier)) {
            throw new IllegalLockUsageException("No lock for this identifier was ever obtained");
        }
        DisposableLock lock = this.lockFor(identifier);
        lock.unlock(identifier);
    }

    private boolean isLockAvailableFor(String identifier) {
        return this.locks.containsKey(identifier);
    }

    private DisposableLock lockFor(String identifier) {
        DisposableLock lock = this.locks.get(identifier);
        while (lock == null) {
            this.locks.putIfAbsent(identifier, new DisposableLock());
            lock = this.locks.get(identifier);
        }
        return lock;
    }

    private static final class PubliclyOwnedReentrantLock
    extends ReentrantLock {
        private static final long serialVersionUID = -2259228494514612163L;

        private PubliclyOwnedReentrantLock() {
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        public boolean isHeldBy(Thread thread) {
            return thread.equals(this.getOwner());
        }
    }

    private final class DisposableLock {
        private final PubliclyOwnedReentrantLock lock = new PubliclyOwnedReentrantLock();
        private boolean isClosed = false;

        private DisposableLock() {
        }

        private boolean isHeldByCurrentThread() {
            return this.lock.isHeldByCurrentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock(String identifier) {
            try {
                this.lock.unlock();
            }
            finally {
                this.disposeIfUnused(identifier);
            }
        }

        private boolean lock() {
            try {
                if (!this.lock.tryLock(0L, TimeUnit.NANOSECONDS)) {
                    do {
                        this.checkForDeadlock();
                    } while (!this.lock.tryLock(100L, TimeUnit.MILLISECONDS));
                }
            }
            catch (InterruptedException e) {
                throw new LockAcquisitionFailedException("Thread was interrupted", e);
            }
            if (this.isClosed) {
                this.lock.unlock();
                return false;
            }
            return true;
        }

        private void checkForDeadlock() {
            if (!this.lock.isHeldByCurrentThread() && this.lock.isLocked()) {
                for (Thread thread : IdentifierBasedLock.threadsWaitingForMyLocks(Thread.currentThread())) {
                    if (!this.lock.isHeldBy(thread)) continue;
                    throw new DeadlockException("An imminent deadlock was detected while attempting to acquire a lock");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disposeIfUnused(String identifier) {
            if (this.lock.tryLock()) {
                try {
                    if (this.lock.getHoldCount() == 1) {
                        this.isClosed = true;
                        IdentifierBasedLock.this.locks.remove(identifier, this);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public Collection<Thread> queuedThreads() {
            return this.lock.getQueuedThreads();
        }

        public boolean isHeldBy(Thread owner) {
            return this.lock.isHeldBy(owner);
        }
    }
}

