/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.ConnectionWrapperFactory;
import org.axonframework.common.jdbc.JdbcTransactionException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class UnitOfWorkAwareConnectionProviderWrapper
implements ConnectionProvider {
    private static final String CONNECTION_RESOURCE_NAME = Connection.class.getName();
    private final ConnectionProvider delegate;
    private final boolean inherited;

    public UnitOfWorkAwareConnectionProviderWrapper(ConnectionProvider delegate) {
        this(delegate, true);
    }

    public UnitOfWorkAwareConnectionProviderWrapper(ConnectionProvider delegate, boolean attachAsInheritedResource) {
        this.delegate = delegate;
        this.inherited = attachAsInheritedResource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!CurrentUnitOfWork.isStarted()) {
            return this.delegate.getConnection();
        }
        UnitOfWork uow = CurrentUnitOfWork.get();
        Connection connection = (Connection)uow.getResource(CONNECTION_RESOURCE_NAME);
        if (connection == null || connection.isClosed()) {
            Connection delegateConnection = this.delegate.getConnection();
            connection = ConnectionWrapperFactory.wrap(delegateConnection, UoWAttachedConnection.class, new UoWAttachedConnectionImpl(delegateConnection), new ConnectionWrapperFactory.NoOpCloseHandler());
            uow.attachResource(CONNECTION_RESOURCE_NAME, connection, this.inherited);
            uow.registerListener(new ConnectionManagingUnitOfWorkListenerAdapter());
        }
        return connection;
    }

    private static class ConnectionManagingUnitOfWorkListenerAdapter
    extends UnitOfWorkListenerAdapter {
        private ConnectionManagingUnitOfWorkListenerAdapter() {
        }

        @Override
        public void afterCommit(UnitOfWork unitOfWork) {
            if (!unitOfWork.isTransactional()) {
                this.onPrepareTransactionCommit(unitOfWork, null);
            }
        }

        @Override
        public void onPrepareTransactionCommit(UnitOfWork unitOfWork, Object transaction) {
            Connection connection = (Connection)unitOfWork.getResource(CONNECTION_RESOURCE_NAME);
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                throw new JdbcTransactionException("Unable to commit transaction", e);
            }
        }

        @Override
        public void onCleanup(UnitOfWork unitOfWork) {
            Connection connection = (Connection)unitOfWork.getResource(CONNECTION_RESOURCE_NAME);
            JdbcUtils.closeQuietly(connection);
            if (connection instanceof UoWAttachedConnection) {
                ((UoWAttachedConnection)((Object)connection)).forceClose();
            }
        }

        @Override
        public void onRollback(UnitOfWork unitOfWork, Throwable failureCause) {
            Connection connection = (Connection)unitOfWork.getResource(CONNECTION_RESOURCE_NAME);
            try {
                if (!connection.isClosed() && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                throw new JdbcTransactionException("Unable to rollback transaction", e);
            }
        }
    }

    private static class UoWAttachedConnectionImpl
    implements UoWAttachedConnection {
        private final Connection delegateConnection;

        public UoWAttachedConnectionImpl(Connection delegateConnection) {
            this.delegateConnection = delegateConnection;
        }

        @Override
        public void forceClose() {
            JdbcUtils.closeQuietly(this.delegateConnection);
        }
    }

    private static interface UoWAttachedConnection {
        public void forceClose();
    }
}

