/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ConnectionWrapperFactory {
    private ConnectionWrapperFactory() {
    }

    public static <I> Connection wrap(final Connection connection, final Class<I> wrapperInterface, final I wrapperHandler, final ConnectionCloseHandler closeHandler) {
        return (Connection)Proxy.newProxyInstance(wrapperInterface.getClassLoader(), new Class[]{Connection.class, wrapperInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("equals".equals(method.getName()) && args != null && args.length == 1) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                    return connection.hashCode();
                }
                if (method.getDeclaringClass().isAssignableFrom(wrapperInterface)) {
                    return method.invoke(wrapperHandler, args);
                }
                if ("close".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                    closeHandler.close(connection);
                    return null;
                }
                if ("commit".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                    closeHandler.commit(connection);
                    return null;
                }
                return method.invoke((Object)connection, args);
            }
        });
    }

    public static Connection wrap(final Connection connection, final ConnectionCloseHandler closeHandler) {
        return (Connection)Proxy.newProxyInstance(closeHandler.getClass().getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("equals".equals(method.getName()) && args != null && args.length == 1) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                    return connection.hashCode();
                }
                if ("close".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                    closeHandler.close(connection);
                    return null;
                }
                if ("commit".equals(method.getName()) && ConnectionWrapperFactory.isEmpty(args)) {
                    closeHandler.commit(connection);
                    return null;
                }
                return method.invoke((Object)connection, args);
            }
        });
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static class NoOpCloseHandler
    implements ConnectionCloseHandler {
        @Override
        public void close(Connection connection) {
        }

        @Override
        public void commit(Connection connection) throws SQLException {
            connection.commit();
        }
    }

    public static interface ConnectionCloseHandler {
        public void close(Connection var1);

        public void commit(Connection var1) throws SQLException;
    }
}

