/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.FixedValueParameterResolver;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Priority(value=-1073741824)
public class SpringBeanParameterResolverFactory
implements ParameterResolverFactory,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringBeanParameterResolverFactory.class);
    private ApplicationContext applicationContext;

    @Override
    public ParameterResolver createInstance(Annotation[] memberAnnotations, Class<?> parameterType, Annotation[] parameterAnnotations) {
        if (this.applicationContext == null) {
            return null;
        }
        Map beansFound = this.applicationContext.getBeansOfType(parameterType);
        if (beansFound.isEmpty()) {
            return null;
        }
        if (beansFound.size() > 1) {
            AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                Iterator i$ = beansFound.entrySet().iterator();
                while (i$.hasNext()) {
                    ConfigurableListableBeanFactory clBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
                    Map.Entry bean = i$.next();
                    if (!clBeanFactory.containsBeanDefinition((String)bean.getKey()) || !clBeanFactory.getBeanDefinition((String)bean.getKey()).isPrimary()) continue;
                    return new FixedValueParameterResolver(bean.getValue());
                }
            }
            if (logger.isWarnEnabled()) {
                logger.warn("{} beans of type {} found, but none was marked as primary. Ignoring this parameter.", (Object)beansFound.size(), (Object)parameterType.getSimpleName());
            }
            return null;
        }
        return new FixedValueParameterResolver(beansFound.values().iterator().next());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

