/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.annotation.PriorityAnnotationComparator;

public class MultiParameterResolverFactory
implements ParameterResolverFactory {
    private final ParameterResolverFactory[] factories;

    public static MultiParameterResolverFactory ordered(ParameterResolverFactory ... delegates) {
        return MultiParameterResolverFactory.ordered(Arrays.asList(delegates));
    }

    public static MultiParameterResolverFactory ordered(List<ParameterResolverFactory> delegates) {
        return new MultiParameterResolverFactory(MultiParameterResolverFactory.flatten(delegates));
    }

    public MultiParameterResolverFactory(ParameterResolverFactory ... delegates) {
        this.factories = Arrays.copyOf(delegates, delegates.length);
    }

    public MultiParameterResolverFactory(List<ParameterResolverFactory> delegates) {
        this.factories = delegates.toArray(new ParameterResolverFactory[delegates.size()]);
    }

    private static ParameterResolverFactory[] flatten(List<ParameterResolverFactory> factories) {
        ArrayList<ParameterResolverFactory> flattened = new ArrayList<ParameterResolverFactory>(factories.size());
        for (ParameterResolverFactory parameterResolverFactory : factories) {
            if (parameterResolverFactory instanceof MultiParameterResolverFactory) {
                flattened.addAll(((MultiParameterResolverFactory)parameterResolverFactory).getDelegates());
                continue;
            }
            flattened.add(parameterResolverFactory);
        }
        Collections.sort(flattened, PriorityAnnotationComparator.getInstance());
        return flattened.toArray(new ParameterResolverFactory[flattened.size()]);
    }

    public List<ParameterResolverFactory> getDelegates() {
        return Arrays.asList(this.factories);
    }

    @Override
    public ParameterResolver createInstance(Annotation[] memberAnnotations, Class<?> parameterType, Annotation[] parameterAnnotations) {
        for (ParameterResolverFactory factory : this.factories) {
            ParameterResolver resolver = factory.createInstance(memberAnnotations, parameterType, parameterAnnotations);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }
}

