/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AbstractMessageHandler;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.annotation.UnsupportedHandlerException;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.Message;

public final class MethodMessageHandler
extends AbstractMessageHandler {
    private final Method method;

    public static MethodMessageHandler createFor(Method method, Class<?> explicitPayloadType, ParameterResolverFactory parameterResolverFactory) {
        ParameterResolver[] resolvers = MethodMessageHandler.findResolvers(parameterResolverFactory, method.getAnnotations(), method.getParameterTypes(), method.getParameterAnnotations(), explicitPayloadType == null);
        Class<Object> payloadType = explicitPayloadType;
        if (explicitPayloadType == null) {
            Class<?> firstParameter = method.getParameterTypes()[0];
            payloadType = Message.class.isAssignableFrom(firstParameter) ? Object.class : firstParameter;
        }
        ReflectionUtils.ensureAccessible(method);
        MethodMessageHandler.validate(method, resolvers);
        return new MethodMessageHandler(method, resolvers, payloadType);
    }

    @Override
    public Object invoke(Object target, Message message) throws InvocationTargetException, IllegalAccessException {
        Assert.isTrue(this.method.getDeclaringClass().isInstance(target), "Given target is not an instance of the method's owner.");
        Assert.notNull(message, "Event may not be null");
        Object[] parameterValues = new Object[this.getParameterValueResolvers().length];
        for (int i = 0; i < parameterValues.length; ++i) {
            parameterValues[i] = this.getParameterValueResolvers()[i].resolveParameterValue(message);
        }
        return this.method.invoke(target, parameterValues);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.method.getAnnotation(annotationType);
    }

    private static void validate(Method method, ParameterResolver[] parameterResolvers) {
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (parameterResolvers[i] != null) continue;
            throw new UnsupportedHandlerException(String.format("On method %s, parameter %s is invalid. It is not of any format supported by a providedParameterValueResolver.", method.toGenericString(), i + 1), method);
        }
        if (method.getName().equals("handle") && Arrays.equals(method.getParameterTypes(), new Class[]{EventMessage.class})) {
            throw new UnsupportedHandlerException(String.format("Event Handling class %s contains method %s that has a naming conflict with a method on the EventHandler interface. Please rename the method.", method.getDeclaringClass().getSimpleName(), method.getName()), method);
        }
    }

    private MethodMessageHandler(Method method, ParameterResolver[] parameterValueResolvers, Class payloadType) {
        super(payloadType, method.getDeclaringClass(), parameterValueResolvers);
        this.method = method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return String.format("HandlerMethod %s.%s for payload type %s: %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), this.getPayloadType().getSimpleName(), this.method.toGenericString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodMessageHandler that = (MethodMessageHandler)o;
        return this.method.equals(that.method);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.method.hashCode();
        return result;
    }
}

