/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.common.annotation.HandlerDefinition;
import org.axonframework.common.annotation.MessageHandlerInvocationException;
import org.axonframework.common.annotation.MethodMessageHandler;
import org.axonframework.common.annotation.MethodMessageHandlerInspector;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.Message;

public final class MessageHandlerInvoker {
    private final Object target;
    private final MethodMessageHandlerInspector inspector;

    public MessageHandlerInvoker(Object target, ParameterResolverFactory parameterResolverFactory, boolean allowDuplicates, HandlerDefinition<? super Method> handlerDefinition) {
        this.inspector = MethodMessageHandlerInspector.getInstance(target.getClass(), parameterResolverFactory, allowDuplicates, handlerDefinition);
        this.target = target;
    }

    public Object invokeHandlerMethod(Message parameter) {
        MethodMessageHandler m = this.findHandlerMethod(parameter);
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(this.target, parameter);
        }
        catch (IllegalAccessException e) {
            throw new MessageHandlerInvocationException("Access to the message handler method was denied.", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new MessageHandlerInvocationException("An exception occurred while invoking the handler method.", e);
        }
    }

    public MethodMessageHandler findHandlerMethod(Message message) {
        return this.inspector.findHandlerMethod(message);
    }

    public Class getTargetType() {
        return this.inspector.getTargetType();
    }
}

