/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.axonframework.common.Assert;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.Message;

public abstract class AbstractMessageHandler
implements Comparable<AbstractMessageHandler> {
    private final Score score;
    private final Class<?> payloadType;
    private final ParameterResolver[] parameterValueResolvers;

    protected AbstractMessageHandler(Class<?> payloadType, Class<?> declaringClass, ParameterResolver ... parameterValueResolvers) {
        this.score = new Score(payloadType, declaringClass);
        this.payloadType = payloadType;
        this.parameterValueResolvers = Arrays.copyOf(parameterValueResolvers, parameterValueResolvers.length);
    }

    protected AbstractMessageHandler(AbstractMessageHandler delegate) {
        this.score = delegate.score;
        this.payloadType = delegate.payloadType;
        this.parameterValueResolvers = delegate.parameterValueResolvers;
    }

    public boolean matches(Message message) {
        Assert.notNull(message, "Event may not be null");
        if (this.payloadType != null && !this.payloadType.isAssignableFrom(message.getPayloadType())) {
            return false;
        }
        for (ParameterResolver parameterResolver : this.parameterValueResolvers) {
            if (parameterResolver.matches(message)) continue;
            return false;
        }
        return true;
    }

    public abstract Object invoke(Object var1, Message var2) throws InvocationTargetException, IllegalAccessException;

    public Class getPayloadType() {
        return this.payloadType;
    }

    @Override
    public int compareTo(AbstractMessageHandler o) {
        return this.score.compareTo(o.score);
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractMessageHandler && ((AbstractMessageHandler)obj).score.equals(this.score);
    }

    public int hashCode() {
        return this.score.hashCode();
    }

    protected static ParameterResolver[] findResolvers(ParameterResolverFactory parameterResolverFactory, Annotation[] memberAnnotations, Class<?>[] parameterTypes, Annotation[][] parameterAnnotations, boolean resolvePayload) {
        int parameters = parameterTypes.length;
        ParameterResolver[] parameterValueResolvers = new ParameterResolver[parameters];
        for (int i = 0; i < parameters; ++i) {
            boolean isPayloadParameter = resolvePayload && i == 0;
            parameterValueResolvers[i] = isPayloadParameter && !Message.class.isAssignableFrom(parameterTypes[i]) ? new PayloadParameterResolver(parameterTypes[i]) : parameterResolverFactory.createInstance(memberAnnotations, parameterTypes[i], parameterAnnotations[i]);
        }
        return parameterValueResolvers;
    }

    protected ParameterResolver[] getParameterValueResolvers() {
        return this.parameterValueResolvers;
    }

    public abstract <T extends Annotation> T getAnnotation(Class<T> var1);

    private static final class Score
    implements Comparable<Score> {
        private final int declarationDepth;
        private final int payloadDepth;
        private final String payloadName;

        private Score(Class payloadType, Class<?> declaringClass) {
            this.declarationDepth = this.superClassCount(declaringClass, 0);
            this.payloadDepth = this.superClassCount(payloadType, -255);
            this.payloadName = payloadType.getName();
        }

        private int superClassCount(Class<?> declaringClass, int interfaceScore) {
            if (declaringClass.isInterface()) {
                return interfaceScore;
            }
            int superClasses = 0;
            while (declaringClass != null) {
                ++superClasses;
                declaringClass = declaringClass.getSuperclass();
            }
            return superClasses;
        }

        @Override
        public int compareTo(Score o) {
            if (this.declarationDepth != o.declarationDepth) {
                return o.declarationDepth < this.declarationDepth ? -1 : 1;
            }
            if (this.payloadDepth != o.payloadDepth) {
                return o.payloadDepth < this.payloadDepth ? -1 : 1;
            }
            return this.payloadName.compareTo(o.payloadName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Score score = (Score)o;
            return this.declarationDepth == score.declarationDepth && this.payloadDepth == score.payloadDepth && this.payloadName.equals(score.payloadName);
        }

        public int hashCode() {
            int result = this.declarationDepth;
            result = 31 * result + this.payloadDepth;
            result = 31 * result + this.payloadName.hashCode();
            return result;
        }
    }

    private static class PayloadParameterResolver
    implements ParameterResolver {
        private final Class<?> payloadType;

        public PayloadParameterResolver(Class<?> payloadType) {
            this.payloadType = payloadType;
        }

        public Object resolveParameterValue(Message message) {
            return message.getPayload();
        }

        @Override
        public boolean matches(Message message) {
            return message.getPayloadType() != null && this.payloadType.isAssignableFrom(message.getPayloadType());
        }
    }
}

