/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.Subscribable;
import org.axonframework.common.annotation.ClasspathParameterResolverFactory;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.IntroductionInfo;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.ClassUtils;

public abstract class AbstractAnnotationHandlerBeanPostProcessor<I, T extends I>
implements DestructionAwareBeanPostProcessor,
ApplicationContextAware,
SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAnnotationHandlerBeanPostProcessor.class);
    private final Map<String, T> managedAdapters = new HashMap<String, T>();
    private final Map<String, I> managedProxies = new HashMap<String, I>();
    private ParameterResolverFactory parameterResolverFactory;
    private ApplicationContext applicationContext;
    private volatile boolean running = false;
    private int phase = 0;
    private boolean unsubscribeOnShutdown = true;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> targetClass = bean.getClass();
        ClassLoader classLoader = targetClass.getClassLoader();
        if (this.parameterResolverFactory == null) {
            this.parameterResolverFactory = ClasspathParameterResolverFactory.forClassLoader(classLoader);
        }
        if (this.isPostProcessingCandidate(targetClass)) {
            T adapter = this.initializeAdapterFor(bean, this.parameterResolverFactory);
            I proxy = this.createAdapterProxy(bean, adapter, this.getAdapterInterface(), true, classLoader);
            this.managedAdapters.put(beanName, adapter);
            this.managedProxies.put(beanName, proxy);
            if (this.running) {
                this.subscribe(proxy, adapter);
            }
            return proxy;
        }
        if (!this.getAdapterInterface().isInstance(bean) && this.isPostProcessingCandidate(AopProxyUtils.ultimateTargetClass((Object)bean))) {
            try {
                Object targetBean = ((Advised)bean).getTargetSource().getTarget();
                Object proxyInvokingBean = this.createJavaProxyInvoker(bean, targetBean);
                T adapter = this.initializeAdapterFor(proxyInvokingBean, this.parameterResolverFactory);
                I proxy = this.createAdapterProxy(proxyInvokingBean, adapter, this.getAdapterInterface(), false, classLoader);
                this.managedAdapters.put(beanName, adapter);
                this.managedProxies.put(beanName, proxy);
                if (this.running) {
                    this.subscribe(proxy, adapter);
                }
                return proxy;
            }
            catch (Exception e) {
                throw new AxonConfigurationException("Unable to wrap annotated handler.", e);
            }
        }
        return bean;
    }

    private Object createJavaProxyInvoker(Object javaProxy, Object target) {
        ProxyFactory pf = new ProxyFactory(target);
        pf.addAdvice((Advice)new ProxyOrImplementationInvocationInterceptor(javaProxy, target));
        pf.setProxyTargetClass(true);
        pf.setExposeProxy(true);
        return pf.getProxy(target.getClass().getClassLoader());
    }

    protected abstract Class<I> getAdapterInterface();

    protected abstract boolean isPostProcessingCandidate(Class<?> var1);

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        for (Map.Entry<String, T> entry : this.managedAdapters.entrySet()) {
            this.subscribe(this.managedProxies.get(entry.getKey()), entry.getValue());
        }
        this.running = true;
    }

    public void stop() {
        if (this.unsubscribeOnShutdown) {
            for (Map.Entry<String, T> entry : this.managedAdapters.entrySet()) {
                this.unsubscribe(this.managedProxies.get(entry.getKey()), entry.getValue());
            }
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.running && this.managedProxies.containsKey(beanName)) {
            try {
                if (this.unsubscribeOnShutdown) {
                    this.unsubscribe(this.managedProxies.get(beanName), this.managedAdapters.get(beanName));
                }
            }
            catch (Exception e) {
                logger.error("An exception occurred while unsubscribing an event listener", (Throwable)e);
            }
            finally {
                this.managedAdapters.remove(beanName);
                this.managedProxies.remove(beanName);
            }
        }
    }

    protected abstract void subscribe(I var1, T var2);

    protected abstract void unsubscribe(I var1, T var2);

    protected abstract T initializeAdapterFor(Object var1, ParameterResolverFactory var2);

    private I createAdapterProxy(Object annotatedHandler, T adapter, Class<I> adapterInterface, boolean proxyTargetClass, ClassLoader classLoader) {
        ProxyFactory pf = new ProxyFactory(annotatedHandler);
        pf.addAdvice((Advice)new AdapterIntroductionInterceptor(adapter, adapterInterface));
        pf.addInterface(adapterInterface);
        pf.addInterface(Subscribable.class);
        pf.setProxyTargetClass(proxyTargetClass);
        pf.setExposeProxy(true);
        return (I)pf.getProxy(classLoader);
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setUnsubscribeOnShutdown(boolean unsubscribeOnShutdown) {
        this.unsubscribeOnShutdown = unsubscribeOnShutdown;
    }

    public void setParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
    }

    private static final class AdapterIntroductionInterceptor
    implements IntroductionInfo,
    IntroductionInterceptor {
        private final Object adapter;
        private final Class<?> adapterInterface;

        private AdapterIntroductionInterceptor(Object adapter, Class<?> adapterInterface) {
            this.adapter = adapter;
            this.adapterInterface = adapterInterface;
        }

        public boolean implementsInterface(Class<?> intf) {
            return intf.equals(this.adapterInterface) || Subscribable.class.equals(intf);
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Class<?> declaringClass = invocation.getMethod().getDeclaringClass();
            if (declaringClass.equals(this.adapterInterface) || Subscribable.class.equals(declaringClass)) {
                try {
                    return invocation.getMethod().invoke(this.adapter, invocation.getArguments());
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            return invocation.proceed();
        }

        public Class[] getInterfaces() {
            return new Class[]{this.adapterInterface};
        }
    }

    private static final class ProxyOrImplementationInvocationInterceptor
    implements IntroductionInfo,
    IntroductionInterceptor {
        private final Object proxy;
        private final Method[] proxyMethods;
        private final Class[] interfaces;

        private ProxyOrImplementationInvocationInterceptor(Object proxy, Object implementation) {
            this.proxy = proxy;
            this.proxyMethods = proxy.getClass().getDeclaredMethods();
            this.interfaces = ClassUtils.getAllInterfaces((Object)implementation);
        }

        public boolean implementsInterface(Class<?> intf) {
            for (Class iFace : this.interfaces) {
                if (!intf.equals(iFace)) continue;
                return true;
            }
            return false;
        }

        public Class[] getInterfaces() {
            return this.interfaces;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            try {
                for (Method proxyMethod : this.proxyMethods) {
                    if (!proxyMethod.getName().equals(invocation.getMethod().getName()) || !Arrays.equals(proxyMethod.getParameterTypes(), invocation.getMethod().getParameterTypes())) continue;
                    return proxyMethod.invoke(this.proxy, invocation.getArguments());
                }
                return invocation.proceed();
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

