/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Map;
import java.util.WeakHashMap;
import org.axonframework.common.ReflectionUtils;

public final class IdentifierValidator {
    private static final IdentifierValidator INSTANCE = new IdentifierValidator();
    private static final Object NULL = new Object();
    private final Map<Class<?>, Object> whiteList = new WeakHashMap();

    public static IdentifierValidator getInstance() {
        return INSTANCE;
    }

    public static void validateIdentifier(Class<?> aggregateIdentifierType) {
        if (!IdentifierValidator.getInstance().isValidIdentifier(aggregateIdentifierType)) {
            throw new IllegalArgumentException("One of the events contains an unsuitable aggregate identifier for this EventStore implementation. See reference guide for more information. Suspected class: " + aggregateIdentifierType.getName());
        }
    }

    private IdentifierValidator() {
    }

    public boolean isValidIdentifier(Class<?> identifierType) {
        if (!this.whiteList.containsKey(identifierType)) {
            if (Object.class.equals(ReflectionUtils.declaringClass(identifierType, "toString", new Class[0]))) {
                return false;
            }
            this.whiteList.put(identifierType, NULL);
        }
        return true;
    }
}

